--                                                                    --
--  package                         Copyright (c)  Dmitry A. Kazakov  --
--     Fuzzy.Linguistics.                          Luebeck            --
--        Rightmost_Max                            Autumn, 2005       --
--  Interface                                                         --
--                                Last revision :  14:34 08 Oct 2006  --
--                                                                    --
--  This  library  is  free software; you can redistribute it and/or  --
--  modify it under the terms of the GNU General Public  License  as  --
--  published by the Free Software Foundation; either version  2  of  --
--  the License, or (at your option) any later version. This library  --
--  is distributed in the hope that it will be useful,  but  WITHOUT  --
--  ANY   WARRANTY;   without   even   the   implied   warranty   of  --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  --
--  General  Public  License  for  more  details.  You  should  have  --
--  received  a  copy  of  the GNU General Public License along with  --
--  this library; if not, write to  the  Free  Software  Foundation,  --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.    --
--                                                                    --
--  As a special exception, if other files instantiate generics from  --
--  this unit, or you link this unit with other files to produce  an  --
--  executable, this unit does not by  itself  cause  the  resulting  --
--  executable to be covered by the GNU General Public License. This  --
--  exception  does not however invalidate any other reasons why the  --
--  executable file might be covered by the GNU Public License.       --
--____________________________________________________________________--
--
--  Rightmost_Max -- An empirical defuzzification method
--
--     A - The variable to defuzzify
--
--  The result of defined as:
--
--     Max { X | exists interval L < X < U such that A(L) < A(X) > A(U)
--               and for any L < Y < U, A(Y)=A(X)
--         }
--
--  It  is  the rightmost  value where the membership function reaches a
--  local maximum.  The  result  is  undefined  if  there  is  no  local
--  maximums. 
--
--  Returns :
--
--     Defuzzified value
--
--  Exceptions :
--
--     Constraint_Error - The result is undefined
--
generic
   function Fuzzy.Linguistics.Rightmost_Max (A : Variable)
      return Number;
