--                                                                    --
--  package                         Copyright (c)  Dmitry A. Kazakov  --
--     Strings_Edit.UTF8.Categorization            Luebeck            --
--  Implementation                                 Spring, 2008       --
--                                                                    --
--                                Last revision :  14:35 11 Mar 2025  --
--                                                                    --
--  This  library  is  free software; you can redistribute it and/or  --
--  modify it under the terms of the GNU General Public  License  as  --
--  published by the Free Software Foundation; either version  2  of  --
--  the License, or (at your option) any later version. This library  --
--  is distributed in the hope that it will be useful,  but  WITHOUT  --
--  ANY   WARRANTY;   without   even   the   implied   warranty   of  --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  --
--  General  Public  License  for  more  details.  You  should  have  --
--  received  a  copy  of  the GNU General Public License along with  --
--  this library; if not, write to  the  Free  Software  Foundation,  --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.    --
--                                                                    --
--  As a special exception, if other files instantiate generics from  --
--  this unit, or you link this unit with other files to produce  an  --
--  executable, this unit does not by  itself  cause  the  resulting  --
--  executable to be covered by the GNU General Public License. This  --
--  exception  does not however invalidate any other reasons why the  --
--  executable file might be covered by the GNU Public License.       --
--____________________________________________________________________--

package body Strings_Edit.UTF8.Categorization is

   type Points_Range is record
      From     : UTF8_Code_Point;
      To       : UTF8_Code_Point;
      Category : General_Category;
   end record;
   type Range_Index is range 1..3318;
   type Range_Array is array (Range_Index) of Points_Range;

   Mapping : constant Range_Array :=
   (
      (16#0#,16#1F#,CC),(16#20#,16#20#,ZS),(16#21#,16#23#,PO),
      (16#24#,16#24#,SC),(16#25#,16#27#,PO),(16#28#,16#28#,PS),
      (16#29#,16#29#,PE),(16#2A#,16#2A#,PO),(16#2B#,16#2B#,SM),
      (16#2C#,16#2C#,PO),(16#2D#,16#2D#,PD),(16#2E#,16#2F#,PO),
      (16#30#,16#39#,ND),(16#3A#,16#3B#,PO),(16#3C#,16#3E#,SM),
      (16#3F#,16#40#,PO),(16#41#,16#5A#,LU),(16#5B#,16#5B#,PS),
      (16#5C#,16#5C#,PO),(16#5D#,16#5D#,PE),(16#5E#,16#5E#,SK),
      (16#5F#,16#5F#,PC),(16#60#,16#60#,SK),(16#61#,16#7A#,LL),
      (16#7B#,16#7B#,PS),(16#7C#,16#7C#,SM),(16#7D#,16#7D#,PE),
      (16#7E#,16#7E#,SM),(16#7F#,16#9F#,CC),(16#A0#,16#A0#,ZS),
      (16#A1#,16#A1#,PO),(16#A2#,16#A5#,SC),(16#A6#,16#A6#,SO),
      (16#A7#,16#A7#,PO),(16#A8#,16#A8#,SK),(16#A9#,16#A9#,SO),
      (16#AA#,16#AA#,LO),(16#AB#,16#AB#,PI),(16#AC#,16#AC#,SM),
      (16#AD#,16#AD#,CF),(16#AE#,16#AE#,SO),(16#AF#,16#AF#,SK),
      (16#B0#,16#B0#,SO),(16#B1#,16#B1#,SM),(16#B2#,16#B3#,NO),
      (16#B4#,16#B4#,SK),(16#B5#,16#B5#,LL),(16#B6#,16#B7#,PO),
      (16#B8#,16#B8#,SK),(16#B9#,16#B9#,NO),(16#BA#,16#BA#,LO),
      (16#BB#,16#BB#,PF),(16#BC#,16#BE#,NO),(16#BF#,16#BF#,PO),
      (16#C0#,16#D6#,LU),(16#D7#,16#D7#,SM),(16#D8#,16#DE#,LU),
      (16#DF#,16#F6#,LL),(16#F7#,16#F7#,SM),(16#F8#,16#FF#,LL),
      (16#100#,16#100#,LU),(16#101#,16#101#,LL),(16#102#,16#102#,LU),
      (16#103#,16#103#,LL),(16#104#,16#104#,LU),(16#105#,16#105#,LL),
      (16#106#,16#106#,LU),(16#107#,16#107#,LL),(16#108#,16#108#,LU),
      (16#109#,16#109#,LL),(16#10A#,16#10A#,LU),(16#10B#,16#10B#,LL),
      (16#10C#,16#10C#,LU),(16#10D#,16#10D#,LL),(16#10E#,16#10E#,LU),
      (16#10F#,16#10F#,LL),(16#110#,16#110#,LU),(16#111#,16#111#,LL),
      (16#112#,16#112#,LU),(16#113#,16#113#,LL),(16#114#,16#114#,LU),
      (16#115#,16#115#,LL),(16#116#,16#116#,LU),(16#117#,16#117#,LL),
      (16#118#,16#118#,LU),(16#119#,16#119#,LL),(16#11A#,16#11A#,LU),
      (16#11B#,16#11B#,LL),(16#11C#,16#11C#,LU),(16#11D#,16#11D#,LL),
      (16#11E#,16#11E#,LU),(16#11F#,16#11F#,LL),(16#120#,16#120#,LU),
      (16#121#,16#121#,LL),(16#122#,16#122#,LU),(16#123#,16#123#,LL),
      (16#124#,16#124#,LU),(16#125#,16#125#,LL),(16#126#,16#126#,LU),
      (16#127#,16#127#,LL),(16#128#,16#128#,LU),(16#129#,16#129#,LL),
      (16#12A#,16#12A#,LU),(16#12B#,16#12B#,LL),(16#12C#,16#12C#,LU),
      (16#12D#,16#12D#,LL),(16#12E#,16#12E#,LU),(16#12F#,16#12F#,LL),
      (16#130#,16#130#,LU),(16#131#,16#131#,LL),(16#132#,16#132#,LU),
      (16#133#,16#133#,LL),(16#134#,16#134#,LU),(16#135#,16#135#,LL),
      (16#136#,16#136#,LU),(16#137#,16#138#,LL),(16#139#,16#139#,LU),
      (16#13A#,16#13A#,LL),(16#13B#,16#13B#,LU),(16#13C#,16#13C#,LL),
      (16#13D#,16#13D#,LU),(16#13E#,16#13E#,LL),(16#13F#,16#13F#,LU),
      (16#140#,16#140#,LL),(16#141#,16#141#,LU),(16#142#,16#142#,LL),
      (16#143#,16#143#,LU),(16#144#,16#144#,LL),(16#145#,16#145#,LU),
      (16#146#,16#146#,LL),(16#147#,16#147#,LU),(16#148#,16#149#,LL),
      (16#14A#,16#14A#,LU),(16#14B#,16#14B#,LL),(16#14C#,16#14C#,LU),
      (16#14D#,16#14D#,LL),(16#14E#,16#14E#,LU),(16#14F#,16#14F#,LL),
      (16#150#,16#150#,LU),(16#151#,16#151#,LL),(16#152#,16#152#,LU),
      (16#153#,16#153#,LL),(16#154#,16#154#,LU),(16#155#,16#155#,LL),
      (16#156#,16#156#,LU),(16#157#,16#157#,LL),(16#158#,16#158#,LU),
      (16#159#,16#159#,LL),(16#15A#,16#15A#,LU),(16#15B#,16#15B#,LL),
      (16#15C#,16#15C#,LU),(16#15D#,16#15D#,LL),(16#15E#,16#15E#,LU),
      (16#15F#,16#15F#,LL),(16#160#,16#160#,LU),(16#161#,16#161#,LL),
      (16#162#,16#162#,LU),(16#163#,16#163#,LL),(16#164#,16#164#,LU),
      (16#165#,16#165#,LL),(16#166#,16#166#,LU),(16#167#,16#167#,LL),
      (16#168#,16#168#,LU),(16#169#,16#169#,LL),(16#16A#,16#16A#,LU),
      (16#16B#,16#16B#,LL),(16#16C#,16#16C#,LU),(16#16D#,16#16D#,LL),
      (16#16E#,16#16E#,LU),(16#16F#,16#16F#,LL),(16#170#,16#170#,LU),
      (16#171#,16#171#,LL),(16#172#,16#172#,LU),(16#173#,16#173#,LL),
      (16#174#,16#174#,LU),(16#175#,16#175#,LL),(16#176#,16#176#,LU),
      (16#177#,16#177#,LL),(16#178#,16#179#,LU),(16#17A#,16#17A#,LL),
      (16#17B#,16#17B#,LU),(16#17C#,16#17C#,LL),(16#17D#,16#17D#,LU),
      (16#17E#,16#180#,LL),(16#181#,16#182#,LU),(16#183#,16#183#,LL),
      (16#184#,16#184#,LU),(16#185#,16#185#,LL),(16#186#,16#187#,LU),
      (16#188#,16#188#,LL),(16#189#,16#18B#,LU),(16#18C#,16#18D#,LL),
      (16#18E#,16#191#,LU),(16#192#,16#192#,LL),(16#193#,16#194#,LU),
      (16#195#,16#195#,LL),(16#196#,16#198#,LU),(16#199#,16#19B#,LL),
      (16#19C#,16#19D#,LU),(16#19E#,16#19E#,LL),(16#19F#,16#1A0#,LU),
      (16#1A1#,16#1A1#,LL),(16#1A2#,16#1A2#,LU),(16#1A3#,16#1A3#,LL),
      (16#1A4#,16#1A4#,LU),(16#1A5#,16#1A5#,LL),(16#1A6#,16#1A7#,LU),
      (16#1A8#,16#1A8#,LL),(16#1A9#,16#1A9#,LU),(16#1AA#,16#1AB#,LL),
      (16#1AC#,16#1AC#,LU),(16#1AD#,16#1AD#,LL),(16#1AE#,16#1AF#,LU),
      (16#1B0#,16#1B0#,LL),(16#1B1#,16#1B3#,LU),(16#1B4#,16#1B4#,LL),
      (16#1B5#,16#1B5#,LU),(16#1B6#,16#1B6#,LL),(16#1B7#,16#1B8#,LU),
      (16#1B9#,16#1BA#,LL),(16#1BB#,16#1BB#,LO),(16#1BC#,16#1BC#,LU),
      (16#1BD#,16#1BF#,LL),(16#1C0#,16#1C3#,LO),(16#1C4#,16#1C4#,LU),
      (16#1C5#,16#1C5#,LT),(16#1C6#,16#1C6#,LL),(16#1C7#,16#1C7#,LU),
      (16#1C8#,16#1C8#,LT),(16#1C9#,16#1C9#,LL),(16#1CA#,16#1CA#,LU),
      (16#1CB#,16#1CB#,LT),(16#1CC#,16#1CC#,LL),(16#1CD#,16#1CD#,LU),
      (16#1CE#,16#1CE#,LL),(16#1CF#,16#1CF#,LU),(16#1D0#,16#1D0#,LL),
      (16#1D1#,16#1D1#,LU),(16#1D2#,16#1D2#,LL),(16#1D3#,16#1D3#,LU),
      (16#1D4#,16#1D4#,LL),(16#1D5#,16#1D5#,LU),(16#1D6#,16#1D6#,LL),
      (16#1D7#,16#1D7#,LU),(16#1D8#,16#1D8#,LL),(16#1D9#,16#1D9#,LU),
      (16#1DA#,16#1DA#,LL),(16#1DB#,16#1DB#,LU),(16#1DC#,16#1DD#,LL),
      (16#1DE#,16#1DE#,LU),(16#1DF#,16#1DF#,LL),(16#1E0#,16#1E0#,LU),
      (16#1E1#,16#1E1#,LL),(16#1E2#,16#1E2#,LU),(16#1E3#,16#1E3#,LL),
      (16#1E4#,16#1E4#,LU),(16#1E5#,16#1E5#,LL),(16#1E6#,16#1E6#,LU),
      (16#1E7#,16#1E7#,LL),(16#1E8#,16#1E8#,LU),(16#1E9#,16#1E9#,LL),
      (16#1EA#,16#1EA#,LU),(16#1EB#,16#1EB#,LL),(16#1EC#,16#1EC#,LU),
      (16#1ED#,16#1ED#,LL),(16#1EE#,16#1EE#,LU),(16#1EF#,16#1F0#,LL),
      (16#1F1#,16#1F1#,LU),(16#1F2#,16#1F2#,LT),(16#1F3#,16#1F3#,LL),
      (16#1F4#,16#1F4#,LU),(16#1F5#,16#1F5#,LL),(16#1F6#,16#1F8#,LU),
      (16#1F9#,16#1F9#,LL),(16#1FA#,16#1FA#,LU),(16#1FB#,16#1FB#,LL),
      (16#1FC#,16#1FC#,LU),(16#1FD#,16#1FD#,LL),(16#1FE#,16#1FE#,LU),
      (16#1FF#,16#1FF#,LL),(16#200#,16#200#,LU),(16#201#,16#201#,LL),
      (16#202#,16#202#,LU),(16#203#,16#203#,LL),(16#204#,16#204#,LU),
      (16#205#,16#205#,LL),(16#206#,16#206#,LU),(16#207#,16#207#,LL),
      (16#208#,16#208#,LU),(16#209#,16#209#,LL),(16#20A#,16#20A#,LU),
      (16#20B#,16#20B#,LL),(16#20C#,16#20C#,LU),(16#20D#,16#20D#,LL),
      (16#20E#,16#20E#,LU),(16#20F#,16#20F#,LL),(16#210#,16#210#,LU),
      (16#211#,16#211#,LL),(16#212#,16#212#,LU),(16#213#,16#213#,LL),
      (16#214#,16#214#,LU),(16#215#,16#215#,LL),(16#216#,16#216#,LU),
      (16#217#,16#217#,LL),(16#218#,16#218#,LU),(16#219#,16#219#,LL),
      (16#21A#,16#21A#,LU),(16#21B#,16#21B#,LL),(16#21C#,16#21C#,LU),
      (16#21D#,16#21D#,LL),(16#21E#,16#21E#,LU),(16#21F#,16#21F#,LL),
      (16#220#,16#220#,LU),(16#221#,16#221#,LL),(16#222#,16#222#,LU),
      (16#223#,16#223#,LL),(16#224#,16#224#,LU),(16#225#,16#225#,LL),
      (16#226#,16#226#,LU),(16#227#,16#227#,LL),(16#228#,16#228#,LU),
      (16#229#,16#229#,LL),(16#22A#,16#22A#,LU),(16#22B#,16#22B#,LL),
      (16#22C#,16#22C#,LU),(16#22D#,16#22D#,LL),(16#22E#,16#22E#,LU),
      (16#22F#,16#22F#,LL),(16#230#,16#230#,LU),(16#231#,16#231#,LL),
      (16#232#,16#232#,LU),(16#233#,16#239#,LL),(16#23A#,16#23B#,LU),
      (16#23C#,16#23C#,LL),(16#23D#,16#23E#,LU),(16#23F#,16#240#,LL),
      (16#241#,16#241#,LU),(16#242#,16#242#,LL),(16#243#,16#246#,LU),
      (16#247#,16#247#,LL),(16#248#,16#248#,LU),(16#249#,16#249#,LL),
      (16#24A#,16#24A#,LU),(16#24B#,16#24B#,LL),(16#24C#,16#24C#,LU),
      (16#24D#,16#24D#,LL),(16#24E#,16#24E#,LU),(16#24F#,16#293#,LL),
      (16#294#,16#294#,LO),(16#295#,16#2AF#,LL),(16#2B0#,16#2C1#,LM),
      (16#2C2#,16#2C5#,SK),(16#2C6#,16#2D1#,LM),(16#2D2#,16#2DF#,SK),
      (16#2E0#,16#2E4#,LM),(16#2E5#,16#2EB#,SK),(16#2EC#,16#2EC#,LM),
      (16#2ED#,16#2ED#,SK),(16#2EE#,16#2EE#,LM),(16#2EF#,16#2FF#,SK),
      (16#300#,16#36F#,MN),(16#370#,16#370#,LU),(16#371#,16#371#,LL),
      (16#372#,16#372#,LU),(16#373#,16#373#,LL),(16#374#,16#374#,LM),
      (16#375#,16#375#,SK),(16#376#,16#376#,LU),(16#377#,16#377#,LL),
      (16#37A#,16#37A#,LM),(16#37B#,16#37D#,LL),(16#37E#,16#37E#,PO),
      (16#37F#,16#37F#,LU),(16#384#,16#385#,SK),(16#386#,16#386#,LU),
      (16#387#,16#387#,PO),(16#388#,16#38A#,LU),(16#38C#,16#38C#,LU),
      (16#38E#,16#38F#,LU),(16#390#,16#390#,LL),(16#391#,16#3A1#,LU),
      (16#3A3#,16#3AB#,LU),(16#3AC#,16#3CE#,LL),(16#3CF#,16#3CF#,LU),
      (16#3D0#,16#3D1#,LL),(16#3D2#,16#3D4#,LU),(16#3D5#,16#3D7#,LL),
      (16#3D8#,16#3D8#,LU),(16#3D9#,16#3D9#,LL),(16#3DA#,16#3DA#,LU),
      (16#3DB#,16#3DB#,LL),(16#3DC#,16#3DC#,LU),(16#3DD#,16#3DD#,LL),
      (16#3DE#,16#3DE#,LU),(16#3DF#,16#3DF#,LL),(16#3E0#,16#3E0#,LU),
      (16#3E1#,16#3E1#,LL),(16#3E2#,16#3E2#,LU),(16#3E3#,16#3E3#,LL),
      (16#3E4#,16#3E4#,LU),(16#3E5#,16#3E5#,LL),(16#3E6#,16#3E6#,LU),
      (16#3E7#,16#3E7#,LL),(16#3E8#,16#3E8#,LU),(16#3E9#,16#3E9#,LL),
      (16#3EA#,16#3EA#,LU),(16#3EB#,16#3EB#,LL),(16#3EC#,16#3EC#,LU),
      (16#3ED#,16#3ED#,LL),(16#3EE#,16#3EE#,LU),(16#3EF#,16#3F3#,LL),
      (16#3F4#,16#3F4#,LU),(16#3F5#,16#3F5#,LL),(16#3F6#,16#3F6#,SM),
      (16#3F7#,16#3F7#,LU),(16#3F8#,16#3F8#,LL),(16#3F9#,16#3FA#,LU),
      (16#3FB#,16#3FC#,LL),(16#3FD#,16#42F#,LU),(16#430#,16#45F#,LL),
      (16#460#,16#460#,LU),(16#461#,16#461#,LL),(16#462#,16#462#,LU),
      (16#463#,16#463#,LL),(16#464#,16#464#,LU),(16#465#,16#465#,LL),
      (16#466#,16#466#,LU),(16#467#,16#467#,LL),(16#468#,16#468#,LU),
      (16#469#,16#469#,LL),(16#46A#,16#46A#,LU),(16#46B#,16#46B#,LL),
      (16#46C#,16#46C#,LU),(16#46D#,16#46D#,LL),(16#46E#,16#46E#,LU),
      (16#46F#,16#46F#,LL),(16#470#,16#470#,LU),(16#471#,16#471#,LL),
      (16#472#,16#472#,LU),(16#473#,16#473#,LL),(16#474#,16#474#,LU),
      (16#475#,16#475#,LL),(16#476#,16#476#,LU),(16#477#,16#477#,LL),
      (16#478#,16#478#,LU),(16#479#,16#479#,LL),(16#47A#,16#47A#,LU),
      (16#47B#,16#47B#,LL),(16#47C#,16#47C#,LU),(16#47D#,16#47D#,LL),
      (16#47E#,16#47E#,LU),(16#47F#,16#47F#,LL),(16#480#,16#480#,LU),
      (16#481#,16#481#,LL),(16#482#,16#482#,SO),(16#483#,16#487#,MN),
      (16#488#,16#489#,ME),(16#48A#,16#48A#,LU),(16#48B#,16#48B#,LL),
      (16#48C#,16#48C#,LU),(16#48D#,16#48D#,LL),(16#48E#,16#48E#,LU),
      (16#48F#,16#48F#,LL),(16#490#,16#490#,LU),(16#491#,16#491#,LL),
      (16#492#,16#492#,LU),(16#493#,16#493#,LL),(16#494#,16#494#,LU),
      (16#495#,16#495#,LL),(16#496#,16#496#,LU),(16#497#,16#497#,LL),
      (16#498#,16#498#,LU),(16#499#,16#499#,LL),(16#49A#,16#49A#,LU),
      (16#49B#,16#49B#,LL),(16#49C#,16#49C#,LU),(16#49D#,16#49D#,LL),
      (16#49E#,16#49E#,LU),(16#49F#,16#49F#,LL),(16#4A0#,16#4A0#,LU),
      (16#4A1#,16#4A1#,LL),(16#4A2#,16#4A2#,LU),(16#4A3#,16#4A3#,LL),
      (16#4A4#,16#4A4#,LU),(16#4A5#,16#4A5#,LL),(16#4A6#,16#4A6#,LU),
      (16#4A7#,16#4A7#,LL),(16#4A8#,16#4A8#,LU),(16#4A9#,16#4A9#,LL),
      (16#4AA#,16#4AA#,LU),(16#4AB#,16#4AB#,LL),(16#4AC#,16#4AC#,LU),
      (16#4AD#,16#4AD#,LL),(16#4AE#,16#4AE#,LU),(16#4AF#,16#4AF#,LL),
      (16#4B0#,16#4B0#,LU),(16#4B1#,16#4B1#,LL),(16#4B2#,16#4B2#,LU),
      (16#4B3#,16#4B3#,LL),(16#4B4#,16#4B4#,LU),(16#4B5#,16#4B5#,LL),
      (16#4B6#,16#4B6#,LU),(16#4B7#,16#4B7#,LL),(16#4B8#,16#4B8#,LU),
      (16#4B9#,16#4B9#,LL),(16#4BA#,16#4BA#,LU),(16#4BB#,16#4BB#,LL),
      (16#4BC#,16#4BC#,LU),(16#4BD#,16#4BD#,LL),(16#4BE#,16#4BE#,LU),
      (16#4BF#,16#4BF#,LL),(16#4C0#,16#4C1#,LU),(16#4C2#,16#4C2#,LL),
      (16#4C3#,16#4C3#,LU),(16#4C4#,16#4C4#,LL),(16#4C5#,16#4C5#,LU),
      (16#4C6#,16#4C6#,LL),(16#4C7#,16#4C7#,LU),(16#4C8#,16#4C8#,LL),
      (16#4C9#,16#4C9#,LU),(16#4CA#,16#4CA#,LL),(16#4CB#,16#4CB#,LU),
      (16#4CC#,16#4CC#,LL),(16#4CD#,16#4CD#,LU),(16#4CE#,16#4CF#,LL),
      (16#4D0#,16#4D0#,LU),(16#4D1#,16#4D1#,LL),(16#4D2#,16#4D2#,LU),
      (16#4D3#,16#4D3#,LL),(16#4D4#,16#4D4#,LU),(16#4D5#,16#4D5#,LL),
      (16#4D6#,16#4D6#,LU),(16#4D7#,16#4D7#,LL),(16#4D8#,16#4D8#,LU),
      (16#4D9#,16#4D9#,LL),(16#4DA#,16#4DA#,LU),(16#4DB#,16#4DB#,LL),
      (16#4DC#,16#4DC#,LU),(16#4DD#,16#4DD#,LL),(16#4DE#,16#4DE#,LU),
      (16#4DF#,16#4DF#,LL),(16#4E0#,16#4E0#,LU),(16#4E1#,16#4E1#,LL),
      (16#4E2#,16#4E2#,LU),(16#4E3#,16#4E3#,LL),(16#4E4#,16#4E4#,LU),
      (16#4E5#,16#4E5#,LL),(16#4E6#,16#4E6#,LU),(16#4E7#,16#4E7#,LL),
      (16#4E8#,16#4E8#,LU),(16#4E9#,16#4E9#,LL),(16#4EA#,16#4EA#,LU),
      (16#4EB#,16#4EB#,LL),(16#4EC#,16#4EC#,LU),(16#4ED#,16#4ED#,LL),
      (16#4EE#,16#4EE#,LU),(16#4EF#,16#4EF#,LL),(16#4F0#,16#4F0#,LU),
      (16#4F1#,16#4F1#,LL),(16#4F2#,16#4F2#,LU),(16#4F3#,16#4F3#,LL),
      (16#4F4#,16#4F4#,LU),(16#4F5#,16#4F5#,LL),(16#4F6#,16#4F6#,LU),
      (16#4F7#,16#4F7#,LL),(16#4F8#,16#4F8#,LU),(16#4F9#,16#4F9#,LL),
      (16#4FA#,16#4FA#,LU),(16#4FB#,16#4FB#,LL),(16#4FC#,16#4FC#,LU),
      (16#4FD#,16#4FD#,LL),(16#4FE#,16#4FE#,LU),(16#4FF#,16#4FF#,LL),
      (16#500#,16#500#,LU),(16#501#,16#501#,LL),(16#502#,16#502#,LU),
      (16#503#,16#503#,LL),(16#504#,16#504#,LU),(16#505#,16#505#,LL),
      (16#506#,16#506#,LU),(16#507#,16#507#,LL),(16#508#,16#508#,LU),
      (16#509#,16#509#,LL),(16#50A#,16#50A#,LU),(16#50B#,16#50B#,LL),
      (16#50C#,16#50C#,LU),(16#50D#,16#50D#,LL),(16#50E#,16#50E#,LU),
      (16#50F#,16#50F#,LL),(16#510#,16#510#,LU),(16#511#,16#511#,LL),
      (16#512#,16#512#,LU),(16#513#,16#513#,LL),(16#514#,16#514#,LU),
      (16#515#,16#515#,LL),(16#516#,16#516#,LU),(16#517#,16#517#,LL),
      (16#518#,16#518#,LU),(16#519#,16#519#,LL),(16#51A#,16#51A#,LU),
      (16#51B#,16#51B#,LL),(16#51C#,16#51C#,LU),(16#51D#,16#51D#,LL),
      (16#51E#,16#51E#,LU),(16#51F#,16#51F#,LL),(16#520#,16#520#,LU),
      (16#521#,16#521#,LL),(16#522#,16#522#,LU),(16#523#,16#523#,LL),
      (16#524#,16#524#,LU),(16#525#,16#525#,LL),(16#526#,16#526#,LU),
      (16#527#,16#527#,LL),(16#528#,16#528#,LU),(16#529#,16#529#,LL),
      (16#52A#,16#52A#,LU),(16#52B#,16#52B#,LL),(16#52C#,16#52C#,LU),
      (16#52D#,16#52D#,LL),(16#52E#,16#52E#,LU),(16#52F#,16#52F#,LL),
      (16#531#,16#556#,LU),(16#559#,16#559#,LM),(16#55A#,16#55F#,PO),
      (16#560#,16#588#,LL),(16#589#,16#589#,PO),(16#58A#,16#58A#,PD),
      (16#58D#,16#58E#,SO),(16#58F#,16#58F#,SC),(16#591#,16#5BD#,MN),
      (16#5BE#,16#5BE#,PD),(16#5BF#,16#5BF#,MN),(16#5C0#,16#5C0#,PO),
      (16#5C1#,16#5C2#,MN),(16#5C3#,16#5C3#,PO),(16#5C4#,16#5C5#,MN),
      (16#5C6#,16#5C6#,PO),(16#5C7#,16#5C7#,MN),(16#5D0#,16#5EA#,LO),
      (16#5EF#,16#5F2#,LO),(16#5F3#,16#5F4#,PO),(16#600#,16#605#,CF),
      (16#606#,16#608#,SM),(16#609#,16#60A#,PO),(16#60B#,16#60B#,SC),
      (16#60C#,16#60D#,PO),(16#60E#,16#60F#,SO),(16#610#,16#61A#,MN),
      (16#61B#,16#61B#,PO),(16#61C#,16#61C#,CF),(16#61D#,16#61F#,PO),
      (16#620#,16#63F#,LO),(16#640#,16#640#,LM),(16#641#,16#64A#,LO),
      (16#64B#,16#65F#,MN),(16#660#,16#669#,ND),(16#66A#,16#66D#,PO),
      (16#66E#,16#66F#,LO),(16#670#,16#670#,MN),(16#671#,16#6D3#,LO),
      (16#6D4#,16#6D4#,PO),(16#6D5#,16#6D5#,LO),(16#6D6#,16#6DC#,MN),
      (16#6DD#,16#6DD#,CF),(16#6DE#,16#6DE#,SO),(16#6DF#,16#6E4#,MN),
      (16#6E5#,16#6E6#,LM),(16#6E7#,16#6E8#,MN),(16#6E9#,16#6E9#,SO),
      (16#6EA#,16#6ED#,MN),(16#6EE#,16#6EF#,LO),(16#6F0#,16#6F9#,ND),
      (16#6FA#,16#6FC#,LO),(16#6FD#,16#6FE#,SO),(16#6FF#,16#6FF#,LO),
      (16#700#,16#70D#,PO),(16#70F#,16#70F#,CF),(16#710#,16#710#,LO),
      (16#711#,16#711#,MN),(16#712#,16#72F#,LO),(16#730#,16#74A#,MN),
      (16#74D#,16#7A5#,LO),(16#7A6#,16#7B0#,MN),(16#7B1#,16#7B1#,LO),
      (16#7C0#,16#7C9#,ND),(16#7CA#,16#7EA#,LO),(16#7EB#,16#7F3#,MN),
      (16#7F4#,16#7F5#,LM),(16#7F6#,16#7F6#,SO),(16#7F7#,16#7F9#,PO),
      (16#7FA#,16#7FA#,LM),(16#7FD#,16#7FD#,MN),(16#7FE#,16#7FF#,SC),
      (16#800#,16#815#,LO),(16#816#,16#819#,MN),(16#81A#,16#81A#,LM),
      (16#81B#,16#823#,MN),(16#824#,16#824#,LM),(16#825#,16#827#,MN),
      (16#828#,16#828#,LM),(16#829#,16#82D#,MN),(16#830#,16#83E#,PO),
      (16#840#,16#858#,LO),(16#859#,16#85B#,MN),(16#85E#,16#85E#,PO),
      (16#860#,16#86A#,LO),(16#870#,16#887#,LO),(16#888#,16#888#,SK),
      (16#889#,16#88E#,LO),(16#890#,16#891#,CF),(16#898#,16#89F#,MN),
      (16#8A0#,16#8C8#,LO),(16#8C9#,16#8C9#,LM),(16#8CA#,16#8E1#,MN),
      (16#8E2#,16#8E2#,CF),(16#8E3#,16#902#,MN),(16#903#,16#903#,MC),
      (16#904#,16#939#,LO),(16#93A#,16#93A#,MN),(16#93B#,16#93B#,MC),
      (16#93C#,16#93C#,MN),(16#93D#,16#93D#,LO),(16#93E#,16#940#,MC),
      (16#941#,16#948#,MN),(16#949#,16#94C#,MC),(16#94D#,16#94D#,MN),
      (16#94E#,16#94F#,MC),(16#950#,16#950#,LO),(16#951#,16#957#,MN),
      (16#958#,16#961#,LO),(16#962#,16#963#,MN),(16#964#,16#965#,PO),
      (16#966#,16#96F#,ND),(16#970#,16#970#,PO),(16#971#,16#971#,LM),
      (16#972#,16#980#,LO),(16#981#,16#981#,MN),(16#982#,16#983#,MC),
      (16#985#,16#98C#,LO),(16#98F#,16#990#,LO),(16#993#,16#9A8#,LO),
      (16#9AA#,16#9B0#,LO),(16#9B2#,16#9B2#,LO),(16#9B6#,16#9B9#,LO),
      (16#9BC#,16#9BC#,MN),(16#9BD#,16#9BD#,LO),(16#9BE#,16#9C0#,MC),
      (16#9C1#,16#9C4#,MN),(16#9C7#,16#9C8#,MC),(16#9CB#,16#9CC#,MC),
      (16#9CD#,16#9CD#,MN),(16#9CE#,16#9CE#,LO),(16#9D7#,16#9D7#,MC),
      (16#9DC#,16#9DD#,LO),(16#9DF#,16#9E1#,LO),(16#9E2#,16#9E3#,MN),
      (16#9E6#,16#9EF#,ND),(16#9F0#,16#9F1#,LO),(16#9F2#,16#9F3#,SC),
      (16#9F4#,16#9F9#,NO),(16#9FA#,16#9FA#,SO),(16#9FB#,16#9FB#,SC),
      (16#9FC#,16#9FC#,LO),(16#9FD#,16#9FD#,PO),(16#9FE#,16#9FE#,MN),
      (16#A01#,16#A02#,MN),(16#A03#,16#A03#,MC),(16#A05#,16#A0A#,LO),
      (16#A0F#,16#A10#,LO),(16#A13#,16#A28#,LO),(16#A2A#,16#A30#,LO),
      (16#A32#,16#A33#,LO),(16#A35#,16#A36#,LO),(16#A38#,16#A39#,LO),
      (16#A3C#,16#A3C#,MN),(16#A3E#,16#A40#,MC),(16#A41#,16#A42#,MN),
      (16#A47#,16#A48#,MN),(16#A4B#,16#A4D#,MN),(16#A51#,16#A51#,MN),
      (16#A59#,16#A5C#,LO),(16#A5E#,16#A5E#,LO),(16#A66#,16#A6F#,ND),
      (16#A70#,16#A71#,MN),(16#A72#,16#A74#,LO),(16#A75#,16#A75#,MN),
      (16#A76#,16#A76#,PO),(16#A81#,16#A82#,MN),(16#A83#,16#A83#,MC),
      (16#A85#,16#A8D#,LO),(16#A8F#,16#A91#,LO),(16#A93#,16#AA8#,LO),
      (16#AAA#,16#AB0#,LO),(16#AB2#,16#AB3#,LO),(16#AB5#,16#AB9#,LO),
      (16#ABC#,16#ABC#,MN),(16#ABD#,16#ABD#,LO),(16#ABE#,16#AC0#,MC),
      (16#AC1#,16#AC5#,MN),(16#AC7#,16#AC8#,MN),(16#AC9#,16#AC9#,MC),
      (16#ACB#,16#ACC#,MC),(16#ACD#,16#ACD#,MN),(16#AD0#,16#AD0#,LO),
      (16#AE0#,16#AE1#,LO),(16#AE2#,16#AE3#,MN),(16#AE6#,16#AEF#,ND),
      (16#AF0#,16#AF0#,PO),(16#AF1#,16#AF1#,SC),(16#AF9#,16#AF9#,LO),
      (16#AFA#,16#AFF#,MN),(16#B01#,16#B01#,MN),(16#B02#,16#B03#,MC),
      (16#B05#,16#B0C#,LO),(16#B0F#,16#B10#,LO),(16#B13#,16#B28#,LO),
      (16#B2A#,16#B30#,LO),(16#B32#,16#B33#,LO),(16#B35#,16#B39#,LO),
      (16#B3C#,16#B3C#,MN),(16#B3D#,16#B3D#,LO),(16#B3E#,16#B3E#,MC),
      (16#B3F#,16#B3F#,MN),(16#B40#,16#B40#,MC),(16#B41#,16#B44#,MN),
      (16#B47#,16#B48#,MC),(16#B4B#,16#B4C#,MC),(16#B4D#,16#B4D#,MN),
      (16#B55#,16#B56#,MN),(16#B57#,16#B57#,MC),(16#B5C#,16#B5D#,LO),
      (16#B5F#,16#B61#,LO),(16#B62#,16#B63#,MN),(16#B66#,16#B6F#,ND),
      (16#B70#,16#B70#,SO),(16#B71#,16#B71#,LO),(16#B72#,16#B77#,NO),
      (16#B82#,16#B82#,MN),(16#B83#,16#B83#,LO),(16#B85#,16#B8A#,LO),
      (16#B8E#,16#B90#,LO),(16#B92#,16#B95#,LO),(16#B99#,16#B9A#,LO),
      (16#B9C#,16#B9C#,LO),(16#B9E#,16#B9F#,LO),(16#BA3#,16#BA4#,LO),
      (16#BA8#,16#BAA#,LO),(16#BAE#,16#BB9#,LO),(16#BBE#,16#BBF#,MC),
      (16#BC0#,16#BC0#,MN),(16#BC1#,16#BC2#,MC),(16#BC6#,16#BC8#,MC),
      (16#BCA#,16#BCC#,MC),(16#BCD#,16#BCD#,MN),(16#BD0#,16#BD0#,LO),
      (16#BD7#,16#BD7#,MC),(16#BE6#,16#BEF#,ND),(16#BF0#,16#BF2#,NO),
      (16#BF3#,16#BF8#,SO),(16#BF9#,16#BF9#,SC),(16#BFA#,16#BFA#,SO),
      (16#C00#,16#C00#,MN),(16#C01#,16#C03#,MC),(16#C04#,16#C04#,MN),
      (16#C05#,16#C0C#,LO),(16#C0E#,16#C10#,LO),(16#C12#,16#C28#,LO),
      (16#C2A#,16#C39#,LO),(16#C3C#,16#C3C#,MN),(16#C3D#,16#C3D#,LO),
      (16#C3E#,16#C40#,MN),(16#C41#,16#C44#,MC),(16#C46#,16#C48#,MN),
      (16#C4A#,16#C4D#,MN),(16#C55#,16#C56#,MN),(16#C58#,16#C5A#,LO),
      (16#C5D#,16#C5D#,LO),(16#C60#,16#C61#,LO),(16#C62#,16#C63#,MN),
      (16#C66#,16#C6F#,ND),(16#C77#,16#C77#,PO),(16#C78#,16#C7E#,NO),
      (16#C7F#,16#C7F#,SO),(16#C80#,16#C80#,LO),(16#C81#,16#C81#,MN),
      (16#C82#,16#C83#,MC),(16#C84#,16#C84#,PO),(16#C85#,16#C8C#,LO),
      (16#C8E#,16#C90#,LO),(16#C92#,16#CA8#,LO),(16#CAA#,16#CB3#,LO),
      (16#CB5#,16#CB9#,LO),(16#CBC#,16#CBC#,MN),(16#CBD#,16#CBD#,LO),
      (16#CBE#,16#CBE#,MC),(16#CBF#,16#CBF#,MN),(16#CC0#,16#CC4#,MC),
      (16#CC6#,16#CC6#,MN),(16#CC7#,16#CC8#,MC),(16#CCA#,16#CCB#,MC),
      (16#CCC#,16#CCD#,MN),(16#CD5#,16#CD6#,MC),(16#CDD#,16#CDE#,LO),
      (16#CE0#,16#CE1#,LO),(16#CE2#,16#CE3#,MN),(16#CE6#,16#CEF#,ND),
      (16#CF1#,16#CF2#,LO),(16#CF3#,16#CF3#,MC),(16#D00#,16#D01#,MN),
      (16#D02#,16#D03#,MC),(16#D04#,16#D0C#,LO),(16#D0E#,16#D10#,LO),
      (16#D12#,16#D3A#,LO),(16#D3B#,16#D3C#,MN),(16#D3D#,16#D3D#,LO),
      (16#D3E#,16#D40#,MC),(16#D41#,16#D44#,MN),(16#D46#,16#D48#,MC),
      (16#D4A#,16#D4C#,MC),(16#D4D#,16#D4D#,MN),(16#D4E#,16#D4E#,LO),
      (16#D4F#,16#D4F#,SO),(16#D54#,16#D56#,LO),(16#D57#,16#D57#,MC),
      (16#D58#,16#D5E#,NO),(16#D5F#,16#D61#,LO),(16#D62#,16#D63#,MN),
      (16#D66#,16#D6F#,ND),(16#D70#,16#D78#,NO),(16#D79#,16#D79#,SO),
      (16#D7A#,16#D7F#,LO),(16#D81#,16#D81#,MN),(16#D82#,16#D83#,MC),
      (16#D85#,16#D96#,LO),(16#D9A#,16#DB1#,LO),(16#DB3#,16#DBB#,LO),
      (16#DBD#,16#DBD#,LO),(16#DC0#,16#DC6#,LO),(16#DCA#,16#DCA#,MN),
      (16#DCF#,16#DD1#,MC),(16#DD2#,16#DD4#,MN),(16#DD6#,16#DD6#,MN),
      (16#DD8#,16#DDF#,MC),(16#DE6#,16#DEF#,ND),(16#DF2#,16#DF3#,MC),
      (16#DF4#,16#DF4#,PO),(16#E01#,16#E30#,LO),(16#E31#,16#E31#,MN),
      (16#E32#,16#E33#,LO),(16#E34#,16#E3A#,MN),(16#E3F#,16#E3F#,SC),
      (16#E40#,16#E45#,LO),(16#E46#,16#E46#,LM),(16#E47#,16#E4E#,MN),
      (16#E4F#,16#E4F#,PO),(16#E50#,16#E59#,ND),(16#E5A#,16#E5B#,PO),
      (16#E81#,16#E82#,LO),(16#E84#,16#E84#,LO),(16#E86#,16#E8A#,LO),
      (16#E8C#,16#EA3#,LO),(16#EA5#,16#EA5#,LO),(16#EA7#,16#EB0#,LO),
      (16#EB1#,16#EB1#,MN),(16#EB2#,16#EB3#,LO),(16#EB4#,16#EBC#,MN),
      (16#EBD#,16#EBD#,LO),(16#EC0#,16#EC4#,LO),(16#EC6#,16#EC6#,LM),
      (16#EC8#,16#ECE#,MN),(16#ED0#,16#ED9#,ND),(16#EDC#,16#EDF#,LO),
      (16#F00#,16#F00#,LO),(16#F01#,16#F03#,SO),(16#F04#,16#F12#,PO),
      (16#F13#,16#F13#,SO),(16#F14#,16#F14#,PO),(16#F15#,16#F17#,SO),
      (16#F18#,16#F19#,MN),(16#F1A#,16#F1F#,SO),(16#F20#,16#F29#,ND),
      (16#F2A#,16#F33#,NO),(16#F34#,16#F34#,SO),(16#F35#,16#F35#,MN),
      (16#F36#,16#F36#,SO),(16#F37#,16#F37#,MN),(16#F38#,16#F38#,SO),
      (16#F39#,16#F39#,MN),(16#F3A#,16#F3A#,PS),(16#F3B#,16#F3B#,PE),
      (16#F3C#,16#F3C#,PS),(16#F3D#,16#F3D#,PE),(16#F3E#,16#F3F#,MC),
      (16#F40#,16#F47#,LO),(16#F49#,16#F6C#,LO),(16#F71#,16#F7E#,MN),
      (16#F7F#,16#F7F#,MC),(16#F80#,16#F84#,MN),(16#F85#,16#F85#,PO),
      (16#F86#,16#F87#,MN),(16#F88#,16#F8C#,LO),(16#F8D#,16#F97#,MN),
      (16#F99#,16#FBC#,MN),(16#FBE#,16#FC5#,SO),(16#FC6#,16#FC6#,MN),
      (16#FC7#,16#FCC#,SO),(16#FCE#,16#FCF#,SO),(16#FD0#,16#FD4#,PO),
      (16#FD5#,16#FD8#,SO),(16#FD9#,16#FDA#,PO),(16#1000#,16#102A#,LO),
      (16#102B#,16#102C#,MC),(16#102D#,16#1030#,MN),(16#1031#,16#1031#,MC),
      (16#1032#,16#1037#,MN),(16#1038#,16#1038#,MC),(16#1039#,16#103A#,MN),
      (16#103B#,16#103C#,MC),(16#103D#,16#103E#,MN),(16#103F#,16#103F#,LO),
      (16#1040#,16#1049#,ND),(16#104A#,16#104F#,PO),(16#1050#,16#1055#,LO),
      (16#1056#,16#1057#,MC),(16#1058#,16#1059#,MN),(16#105A#,16#105D#,LO),
      (16#105E#,16#1060#,MN),(16#1061#,16#1061#,LO),(16#1062#,16#1064#,MC),
      (16#1065#,16#1066#,LO),(16#1067#,16#106D#,MC),(16#106E#,16#1070#,LO),
      (16#1071#,16#1074#,MN),(16#1075#,16#1081#,LO),(16#1082#,16#1082#,MN),
      (16#1083#,16#1084#,MC),(16#1085#,16#1086#,MN),(16#1087#,16#108C#,MC),
      (16#108D#,16#108D#,MN),(16#108E#,16#108E#,LO),(16#108F#,16#108F#,MC),
      (16#1090#,16#1099#,ND),(16#109A#,16#109C#,MC),(16#109D#,16#109D#,MN),
      (16#109E#,16#109F#,SO),(16#10A0#,16#10C5#,LU),(16#10C7#,16#10C7#,LU),
      (16#10CD#,16#10CD#,LU),(16#10D0#,16#10FA#,LL),(16#10FB#,16#10FB#,PO),
      (16#10FC#,16#10FC#,LM),(16#10FD#,16#10FF#,LL),(16#1100#,16#1248#,LO),
      (16#124A#,16#124D#,LO),(16#1250#,16#1256#,LO),(16#1258#,16#1258#,LO),
      (16#125A#,16#125D#,LO),(16#1260#,16#1288#,LO),(16#128A#,16#128D#,LO),
      (16#1290#,16#12B0#,LO),(16#12B2#,16#12B5#,LO),(16#12B8#,16#12BE#,LO),
      (16#12C0#,16#12C0#,LO),(16#12C2#,16#12C5#,LO),(16#12C8#,16#12D6#,LO),
      (16#12D8#,16#1310#,LO),(16#1312#,16#1315#,LO),(16#1318#,16#135A#,LO),
      (16#135D#,16#135F#,MN),(16#1360#,16#1368#,PO),(16#1369#,16#137C#,NO),
      (16#1380#,16#138F#,LO),(16#1390#,16#1399#,SO),(16#13A0#,16#13F5#,LU),
      (16#13F8#,16#13FD#,LL),(16#1400#,16#1400#,PD),(16#1401#,16#166C#,LO),
      (16#166D#,16#166D#,SO),(16#166E#,16#166E#,PO),(16#166F#,16#167F#,LO),
      (16#1680#,16#1680#,ZS),(16#1681#,16#169A#,LO),(16#169B#,16#169B#,PS),
      (16#169C#,16#169C#,PE),(16#16A0#,16#16EA#,LO),(16#16EB#,16#16ED#,PO),
      (16#16EE#,16#16F0#,NL),(16#16F1#,16#16F8#,LO),(16#1700#,16#1711#,LO),
      (16#1712#,16#1714#,MN),(16#1715#,16#1715#,MC),(16#171F#,16#1731#,LO),
      (16#1732#,16#1733#,MN),(16#1734#,16#1734#,MC),(16#1735#,16#1736#,PO),
      (16#1740#,16#1751#,LO),(16#1752#,16#1753#,MN),(16#1760#,16#176C#,LO),
      (16#176E#,16#1770#,LO),(16#1772#,16#1773#,MN),(16#1780#,16#17B3#,LO),
      (16#17B4#,16#17B5#,MN),(16#17B6#,16#17B6#,MC),(16#17B7#,16#17BD#,MN),
      (16#17BE#,16#17C5#,MC),(16#17C6#,16#17C6#,MN),(16#17C7#,16#17C8#,MC),
      (16#17C9#,16#17D3#,MN),(16#17D4#,16#17D6#,PO),(16#17D7#,16#17D7#,LM),
      (16#17D8#,16#17DA#,PO),(16#17DB#,16#17DB#,SC),(16#17DC#,16#17DC#,LO),
      (16#17DD#,16#17DD#,MN),(16#17E0#,16#17E9#,ND),(16#17F0#,16#17F9#,NO),
      (16#1800#,16#1805#,PO),(16#1806#,16#1806#,PD),(16#1807#,16#180A#,PO),
      (16#180B#,16#180D#,MN),(16#180E#,16#180E#,CF),(16#180F#,16#180F#,MN),
      (16#1810#,16#1819#,ND),(16#1820#,16#1842#,LO),(16#1843#,16#1843#,LM),
      (16#1844#,16#1878#,LO),(16#1880#,16#1884#,LO),(16#1885#,16#1886#,MN),
      (16#1887#,16#18A8#,LO),(16#18A9#,16#18A9#,MN),(16#18AA#,16#18AA#,LO),
      (16#18B0#,16#18F5#,LO),(16#1900#,16#191E#,LO),(16#1920#,16#1922#,MN),
      (16#1923#,16#1926#,MC),(16#1927#,16#1928#,MN),(16#1929#,16#192B#,MC),
      (16#1930#,16#1931#,MC),(16#1932#,16#1932#,MN),(16#1933#,16#1938#,MC),
      (16#1939#,16#193B#,MN),(16#1940#,16#1940#,SO),(16#1944#,16#1945#,PO),
      (16#1946#,16#194F#,ND),(16#1950#,16#196D#,LO),(16#1970#,16#1974#,LO),
      (16#1980#,16#19AB#,LO),(16#19B0#,16#19C9#,LO),(16#19D0#,16#19D9#,ND),
      (16#19DA#,16#19DA#,NO),(16#19DE#,16#19FF#,SO),(16#1A00#,16#1A16#,LO),
      (16#1A17#,16#1A18#,MN),(16#1A19#,16#1A1A#,MC),(16#1A1B#,16#1A1B#,MN),
      (16#1A1E#,16#1A1F#,PO),(16#1A20#,16#1A54#,LO),(16#1A55#,16#1A55#,MC),
      (16#1A56#,16#1A56#,MN),(16#1A57#,16#1A57#,MC),(16#1A58#,16#1A5E#,MN),
      (16#1A60#,16#1A60#,MN),(16#1A61#,16#1A61#,MC),(16#1A62#,16#1A62#,MN),
      (16#1A63#,16#1A64#,MC),(16#1A65#,16#1A6C#,MN),(16#1A6D#,16#1A72#,MC),
      (16#1A73#,16#1A7C#,MN),(16#1A7F#,16#1A7F#,MN),(16#1A80#,16#1A89#,ND),
      (16#1A90#,16#1A99#,ND),(16#1AA0#,16#1AA6#,PO),(16#1AA7#,16#1AA7#,LM),
      (16#1AA8#,16#1AAD#,PO),(16#1AB0#,16#1ABD#,MN),(16#1ABE#,16#1ABE#,ME),
      (16#1ABF#,16#1ACE#,MN),(16#1B00#,16#1B03#,MN),(16#1B04#,16#1B04#,MC),
      (16#1B05#,16#1B33#,LO),(16#1B34#,16#1B34#,MN),(16#1B35#,16#1B35#,MC),
      (16#1B36#,16#1B3A#,MN),(16#1B3B#,16#1B3B#,MC),(16#1B3C#,16#1B3C#,MN),
      (16#1B3D#,16#1B41#,MC),(16#1B42#,16#1B42#,MN),(16#1B43#,16#1B44#,MC),
      (16#1B45#,16#1B4C#,LO),(16#1B50#,16#1B59#,ND),(16#1B5A#,16#1B60#,PO),
      (16#1B61#,16#1B6A#,SO),(16#1B6B#,16#1B73#,MN),(16#1B74#,16#1B7C#,SO),
      (16#1B7D#,16#1B7E#,PO),(16#1B80#,16#1B81#,MN),(16#1B82#,16#1B82#,MC),
      (16#1B83#,16#1BA0#,LO),(16#1BA1#,16#1BA1#,MC),(16#1BA2#,16#1BA5#,MN),
      (16#1BA6#,16#1BA7#,MC),(16#1BA8#,16#1BA9#,MN),(16#1BAA#,16#1BAA#,MC),
      (16#1BAB#,16#1BAD#,MN),(16#1BAE#,16#1BAF#,LO),(16#1BB0#,16#1BB9#,ND),
      (16#1BBA#,16#1BE5#,LO),(16#1BE6#,16#1BE6#,MN),(16#1BE7#,16#1BE7#,MC),
      (16#1BE8#,16#1BE9#,MN),(16#1BEA#,16#1BEC#,MC),(16#1BED#,16#1BED#,MN),
      (16#1BEE#,16#1BEE#,MC),(16#1BEF#,16#1BF1#,MN),(16#1BF2#,16#1BF3#,MC),
      (16#1BFC#,16#1BFF#,PO),(16#1C00#,16#1C23#,LO),(16#1C24#,16#1C2B#,MC),
      (16#1C2C#,16#1C33#,MN),(16#1C34#,16#1C35#,MC),(16#1C36#,16#1C37#,MN),
      (16#1C3B#,16#1C3F#,PO),(16#1C40#,16#1C49#,ND),(16#1C4D#,16#1C4F#,LO),
      (16#1C50#,16#1C59#,ND),(16#1C5A#,16#1C77#,LO),(16#1C78#,16#1C7D#,LM),
      (16#1C7E#,16#1C7F#,PO),(16#1C80#,16#1C88#,LL),(16#1C90#,16#1CBA#,LU),
      (16#1CBD#,16#1CBF#,LU),(16#1CC0#,16#1CC7#,PO),(16#1CD0#,16#1CD2#,MN),
      (16#1CD3#,16#1CD3#,PO),(16#1CD4#,16#1CE0#,MN),(16#1CE1#,16#1CE1#,MC),
      (16#1CE2#,16#1CE8#,MN),(16#1CE9#,16#1CEC#,LO),(16#1CED#,16#1CED#,MN),
      (16#1CEE#,16#1CF3#,LO),(16#1CF4#,16#1CF4#,MN),(16#1CF5#,16#1CF6#,LO),
      (16#1CF7#,16#1CF7#,MC),(16#1CF8#,16#1CF9#,MN),(16#1CFA#,16#1CFA#,LO),
      (16#1D00#,16#1D2B#,LL),(16#1D2C#,16#1D6A#,LM),(16#1D6B#,16#1D77#,LL),
      (16#1D78#,16#1D78#,LM),(16#1D79#,16#1D9A#,LL),(16#1D9B#,16#1DBF#,LM),
      (16#1DC0#,16#1DFF#,MN),(16#1E00#,16#1E00#,LU),(16#1E01#,16#1E01#,LL),
      (16#1E02#,16#1E02#,LU),(16#1E03#,16#1E03#,LL),(16#1E04#,16#1E04#,LU),
      (16#1E05#,16#1E05#,LL),(16#1E06#,16#1E06#,LU),(16#1E07#,16#1E07#,LL),
      (16#1E08#,16#1E08#,LU),(16#1E09#,16#1E09#,LL),(16#1E0A#,16#1E0A#,LU),
      (16#1E0B#,16#1E0B#,LL),(16#1E0C#,16#1E0C#,LU),(16#1E0D#,16#1E0D#,LL),
      (16#1E0E#,16#1E0E#,LU),(16#1E0F#,16#1E0F#,LL),(16#1E10#,16#1E10#,LU),
      (16#1E11#,16#1E11#,LL),(16#1E12#,16#1E12#,LU),(16#1E13#,16#1E13#,LL),
      (16#1E14#,16#1E14#,LU),(16#1E15#,16#1E15#,LL),(16#1E16#,16#1E16#,LU),
      (16#1E17#,16#1E17#,LL),(16#1E18#,16#1E18#,LU),(16#1E19#,16#1E19#,LL),
      (16#1E1A#,16#1E1A#,LU),(16#1E1B#,16#1E1B#,LL),(16#1E1C#,16#1E1C#,LU),
      (16#1E1D#,16#1E1D#,LL),(16#1E1E#,16#1E1E#,LU),(16#1E1F#,16#1E1F#,LL),
      (16#1E20#,16#1E20#,LU),(16#1E21#,16#1E21#,LL),(16#1E22#,16#1E22#,LU),
      (16#1E23#,16#1E23#,LL),(16#1E24#,16#1E24#,LU),(16#1E25#,16#1E25#,LL),
      (16#1E26#,16#1E26#,LU),(16#1E27#,16#1E27#,LL),(16#1E28#,16#1E28#,LU),
      (16#1E29#,16#1E29#,LL),(16#1E2A#,16#1E2A#,LU),(16#1E2B#,16#1E2B#,LL),
      (16#1E2C#,16#1E2C#,LU),(16#1E2D#,16#1E2D#,LL),(16#1E2E#,16#1E2E#,LU),
      (16#1E2F#,16#1E2F#,LL),(16#1E30#,16#1E30#,LU),(16#1E31#,16#1E31#,LL),
      (16#1E32#,16#1E32#,LU),(16#1E33#,16#1E33#,LL),(16#1E34#,16#1E34#,LU),
      (16#1E35#,16#1E35#,LL),(16#1E36#,16#1E36#,LU),(16#1E37#,16#1E37#,LL),
      (16#1E38#,16#1E38#,LU),(16#1E39#,16#1E39#,LL),(16#1E3A#,16#1E3A#,LU),
      (16#1E3B#,16#1E3B#,LL),(16#1E3C#,16#1E3C#,LU),(16#1E3D#,16#1E3D#,LL),
      (16#1E3E#,16#1E3E#,LU),(16#1E3F#,16#1E3F#,LL),(16#1E40#,16#1E40#,LU),
      (16#1E41#,16#1E41#,LL),(16#1E42#,16#1E42#,LU),(16#1E43#,16#1E43#,LL),
      (16#1E44#,16#1E44#,LU),(16#1E45#,16#1E45#,LL),(16#1E46#,16#1E46#,LU),
      (16#1E47#,16#1E47#,LL),(16#1E48#,16#1E48#,LU),(16#1E49#,16#1E49#,LL),
      (16#1E4A#,16#1E4A#,LU),(16#1E4B#,16#1E4B#,LL),(16#1E4C#,16#1E4C#,LU),
      (16#1E4D#,16#1E4D#,LL),(16#1E4E#,16#1E4E#,LU),(16#1E4F#,16#1E4F#,LL),
      (16#1E50#,16#1E50#,LU),(16#1E51#,16#1E51#,LL),(16#1E52#,16#1E52#,LU),
      (16#1E53#,16#1E53#,LL),(16#1E54#,16#1E54#,LU),(16#1E55#,16#1E55#,LL),
      (16#1E56#,16#1E56#,LU),(16#1E57#,16#1E57#,LL),(16#1E58#,16#1E58#,LU),
      (16#1E59#,16#1E59#,LL),(16#1E5A#,16#1E5A#,LU),(16#1E5B#,16#1E5B#,LL),
      (16#1E5C#,16#1E5C#,LU),(16#1E5D#,16#1E5D#,LL),(16#1E5E#,16#1E5E#,LU),
      (16#1E5F#,16#1E5F#,LL),(16#1E60#,16#1E60#,LU),(16#1E61#,16#1E61#,LL),
      (16#1E62#,16#1E62#,LU),(16#1E63#,16#1E63#,LL),(16#1E64#,16#1E64#,LU),
      (16#1E65#,16#1E65#,LL),(16#1E66#,16#1E66#,LU),(16#1E67#,16#1E67#,LL),
      (16#1E68#,16#1E68#,LU),(16#1E69#,16#1E69#,LL),(16#1E6A#,16#1E6A#,LU),
      (16#1E6B#,16#1E6B#,LL),(16#1E6C#,16#1E6C#,LU),(16#1E6D#,16#1E6D#,LL),
      (16#1E6E#,16#1E6E#,LU),(16#1E6F#,16#1E6F#,LL),(16#1E70#,16#1E70#,LU),
      (16#1E71#,16#1E71#,LL),(16#1E72#,16#1E72#,LU),(16#1E73#,16#1E73#,LL),
      (16#1E74#,16#1E74#,LU),(16#1E75#,16#1E75#,LL),(16#1E76#,16#1E76#,LU),
      (16#1E77#,16#1E77#,LL),(16#1E78#,16#1E78#,LU),(16#1E79#,16#1E79#,LL),
      (16#1E7A#,16#1E7A#,LU),(16#1E7B#,16#1E7B#,LL),(16#1E7C#,16#1E7C#,LU),
      (16#1E7D#,16#1E7D#,LL),(16#1E7E#,16#1E7E#,LU),(16#1E7F#,16#1E7F#,LL),
      (16#1E80#,16#1E80#,LU),(16#1E81#,16#1E81#,LL),(16#1E82#,16#1E82#,LU),
      (16#1E83#,16#1E83#,LL),(16#1E84#,16#1E84#,LU),(16#1E85#,16#1E85#,LL),
      (16#1E86#,16#1E86#,LU),(16#1E87#,16#1E87#,LL),(16#1E88#,16#1E88#,LU),
      (16#1E89#,16#1E89#,LL),(16#1E8A#,16#1E8A#,LU),(16#1E8B#,16#1E8B#,LL),
      (16#1E8C#,16#1E8C#,LU),(16#1E8D#,16#1E8D#,LL),(16#1E8E#,16#1E8E#,LU),
      (16#1E8F#,16#1E8F#,LL),(16#1E90#,16#1E90#,LU),(16#1E91#,16#1E91#,LL),
      (16#1E92#,16#1E92#,LU),(16#1E93#,16#1E93#,LL),(16#1E94#,16#1E94#,LU),
      (16#1E95#,16#1E9D#,LL),(16#1E9E#,16#1E9E#,LU),(16#1E9F#,16#1E9F#,LL),
      (16#1EA0#,16#1EA0#,LU),(16#1EA1#,16#1EA1#,LL),(16#1EA2#,16#1EA2#,LU),
      (16#1EA3#,16#1EA3#,LL),(16#1EA4#,16#1EA4#,LU),(16#1EA5#,16#1EA5#,LL),
      (16#1EA6#,16#1EA6#,LU),(16#1EA7#,16#1EA7#,LL),(16#1EA8#,16#1EA8#,LU),
      (16#1EA9#,16#1EA9#,LL),(16#1EAA#,16#1EAA#,LU),(16#1EAB#,16#1EAB#,LL),
      (16#1EAC#,16#1EAC#,LU),(16#1EAD#,16#1EAD#,LL),(16#1EAE#,16#1EAE#,LU),
      (16#1EAF#,16#1EAF#,LL),(16#1EB0#,16#1EB0#,LU),(16#1EB1#,16#1EB1#,LL),
      (16#1EB2#,16#1EB2#,LU),(16#1EB3#,16#1EB3#,LL),(16#1EB4#,16#1EB4#,LU),
      (16#1EB5#,16#1EB5#,LL),(16#1EB6#,16#1EB6#,LU),(16#1EB7#,16#1EB7#,LL),
      (16#1EB8#,16#1EB8#,LU),(16#1EB9#,16#1EB9#,LL),(16#1EBA#,16#1EBA#,LU),
      (16#1EBB#,16#1EBB#,LL),(16#1EBC#,16#1EBC#,LU),(16#1EBD#,16#1EBD#,LL),
      (16#1EBE#,16#1EBE#,LU),(16#1EBF#,16#1EBF#,LL),(16#1EC0#,16#1EC0#,LU),
      (16#1EC1#,16#1EC1#,LL),(16#1EC2#,16#1EC2#,LU),(16#1EC3#,16#1EC3#,LL),
      (16#1EC4#,16#1EC4#,LU),(16#1EC5#,16#1EC5#,LL),(16#1EC6#,16#1EC6#,LU),
      (16#1EC7#,16#1EC7#,LL),(16#1EC8#,16#1EC8#,LU),(16#1EC9#,16#1EC9#,LL),
      (16#1ECA#,16#1ECA#,LU),(16#1ECB#,16#1ECB#,LL),(16#1ECC#,16#1ECC#,LU),
      (16#1ECD#,16#1ECD#,LL),(16#1ECE#,16#1ECE#,LU),(16#1ECF#,16#1ECF#,LL),
      (16#1ED0#,16#1ED0#,LU),(16#1ED1#,16#1ED1#,LL),(16#1ED2#,16#1ED2#,LU),
      (16#1ED3#,16#1ED3#,LL),(16#1ED4#,16#1ED4#,LU),(16#1ED5#,16#1ED5#,LL),
      (16#1ED6#,16#1ED6#,LU),(16#1ED7#,16#1ED7#,LL),(16#1ED8#,16#1ED8#,LU),
      (16#1ED9#,16#1ED9#,LL),(16#1EDA#,16#1EDA#,LU),(16#1EDB#,16#1EDB#,LL),
      (16#1EDC#,16#1EDC#,LU),(16#1EDD#,16#1EDD#,LL),(16#1EDE#,16#1EDE#,LU),
      (16#1EDF#,16#1EDF#,LL),(16#1EE0#,16#1EE0#,LU),(16#1EE1#,16#1EE1#,LL),
      (16#1EE2#,16#1EE2#,LU),(16#1EE3#,16#1EE3#,LL),(16#1EE4#,16#1EE4#,LU),
      (16#1EE5#,16#1EE5#,LL),(16#1EE6#,16#1EE6#,LU),(16#1EE7#,16#1EE7#,LL),
      (16#1EE8#,16#1EE8#,LU),(16#1EE9#,16#1EE9#,LL),(16#1EEA#,16#1EEA#,LU),
      (16#1EEB#,16#1EEB#,LL),(16#1EEC#,16#1EEC#,LU),(16#1EED#,16#1EED#,LL),
      (16#1EEE#,16#1EEE#,LU),(16#1EEF#,16#1EEF#,LL),(16#1EF0#,16#1EF0#,LU),
      (16#1EF1#,16#1EF1#,LL),(16#1EF2#,16#1EF2#,LU),(16#1EF3#,16#1EF3#,LL),
      (16#1EF4#,16#1EF4#,LU),(16#1EF5#,16#1EF5#,LL),(16#1EF6#,16#1EF6#,LU),
      (16#1EF7#,16#1EF7#,LL),(16#1EF8#,16#1EF8#,LU),(16#1EF9#,16#1EF9#,LL),
      (16#1EFA#,16#1EFA#,LU),(16#1EFB#,16#1EFB#,LL),(16#1EFC#,16#1EFC#,LU),
      (16#1EFD#,16#1EFD#,LL),(16#1EFE#,16#1EFE#,LU),(16#1EFF#,16#1F07#,LL),
      (16#1F08#,16#1F0F#,LU),(16#1F10#,16#1F15#,LL),(16#1F18#,16#1F1D#,LU),
      (16#1F20#,16#1F27#,LL),(16#1F28#,16#1F2F#,LU),(16#1F30#,16#1F37#,LL),
      (16#1F38#,16#1F3F#,LU),(16#1F40#,16#1F45#,LL),(16#1F48#,16#1F4D#,LU),
      (16#1F50#,16#1F57#,LL),(16#1F59#,16#1F59#,LU),(16#1F5B#,16#1F5B#,LU),
      (16#1F5D#,16#1F5D#,LU),(16#1F5F#,16#1F5F#,LU),(16#1F60#,16#1F67#,LL),
      (16#1F68#,16#1F6F#,LU),(16#1F70#,16#1F7D#,LL),(16#1F80#,16#1F87#,LL),
      (16#1F88#,16#1F8F#,LT),(16#1F90#,16#1F97#,LL),(16#1F98#,16#1F9F#,LT),
      (16#1FA0#,16#1FA7#,LL),(16#1FA8#,16#1FAF#,LT),(16#1FB0#,16#1FB4#,LL),
      (16#1FB6#,16#1FB7#,LL),(16#1FB8#,16#1FBB#,LU),(16#1FBC#,16#1FBC#,LT),
      (16#1FBD#,16#1FBD#,SK),(16#1FBE#,16#1FBE#,LL),(16#1FBF#,16#1FC1#,SK),
      (16#1FC2#,16#1FC4#,LL),(16#1FC6#,16#1FC7#,LL),(16#1FC8#,16#1FCB#,LU),
      (16#1FCC#,16#1FCC#,LT),(16#1FCD#,16#1FCF#,SK),(16#1FD0#,16#1FD3#,LL),
      (16#1FD6#,16#1FD7#,LL),(16#1FD8#,16#1FDB#,LU),(16#1FDD#,16#1FDF#,SK),
      (16#1FE0#,16#1FE7#,LL),(16#1FE8#,16#1FEC#,LU),(16#1FED#,16#1FEF#,SK),
      (16#1FF2#,16#1FF4#,LL),(16#1FF6#,16#1FF7#,LL),(16#1FF8#,16#1FFB#,LU),
      (16#1FFC#,16#1FFC#,LT),(16#1FFD#,16#1FFE#,SK),(16#2000#,16#200A#,ZS),
      (16#200B#,16#200F#,CF),(16#2010#,16#2015#,PD),(16#2016#,16#2017#,PO),
      (16#2018#,16#2018#,PI),(16#2019#,16#2019#,PF),(16#201A#,16#201A#,PS),
      (16#201B#,16#201C#,PI),(16#201D#,16#201D#,PF),(16#201E#,16#201E#,PS),
      (16#201F#,16#201F#,PI),(16#2020#,16#2027#,PO),(16#2028#,16#2028#,ZL),
      (16#2029#,16#2029#,ZP),(16#202A#,16#202E#,CF),(16#202F#,16#202F#,ZS),
      (16#2030#,16#2038#,PO),(16#2039#,16#2039#,PI),(16#203A#,16#203A#,PF),
      (16#203B#,16#203E#,PO),(16#203F#,16#2040#,PC),(16#2041#,16#2043#,PO),
      (16#2044#,16#2044#,SM),(16#2045#,16#2045#,PS),(16#2046#,16#2046#,PE),
      (16#2047#,16#2051#,PO),(16#2052#,16#2052#,SM),(16#2053#,16#2053#,PO),
      (16#2054#,16#2054#,PC),(16#2055#,16#205E#,PO),(16#205F#,16#205F#,ZS),
      (16#2060#,16#2064#,CF),(16#2066#,16#206F#,CF),(16#2070#,16#2070#,NO),
      (16#2071#,16#2071#,LM),(16#2074#,16#2079#,NO),(16#207A#,16#207C#,SM),
      (16#207D#,16#207D#,PS),(16#207E#,16#207E#,PE),(16#207F#,16#207F#,LM),
      (16#2080#,16#2089#,NO),(16#208A#,16#208C#,SM),(16#208D#,16#208D#,PS),
      (16#208E#,16#208E#,PE),(16#2090#,16#209C#,LM),(16#20A0#,16#20C0#,SC),
      (16#20D0#,16#20DC#,MN),(16#20DD#,16#20E0#,ME),(16#20E1#,16#20E1#,MN),
      (16#20E2#,16#20E4#,ME),(16#20E5#,16#20F0#,MN),(16#2100#,16#2101#,SO),
      (16#2102#,16#2102#,LU),(16#2103#,16#2106#,SO),(16#2107#,16#2107#,LU),
      (16#2108#,16#2109#,SO),(16#210A#,16#210A#,LL),(16#210B#,16#210D#,LU),
      (16#210E#,16#210F#,LL),(16#2110#,16#2112#,LU),(16#2113#,16#2113#,LL),
      (16#2114#,16#2114#,SO),(16#2115#,16#2115#,LU),(16#2116#,16#2117#,SO),
      (16#2118#,16#2118#,SM),(16#2119#,16#211D#,LU),(16#211E#,16#2123#,SO),
      (16#2124#,16#2124#,LU),(16#2125#,16#2125#,SO),(16#2126#,16#2126#,LU),
      (16#2127#,16#2127#,SO),(16#2128#,16#2128#,LU),(16#2129#,16#2129#,SO),
      (16#212A#,16#212D#,LU),(16#212E#,16#212E#,SO),(16#212F#,16#212F#,LL),
      (16#2130#,16#2133#,LU),(16#2134#,16#2134#,LL),(16#2135#,16#2138#,LO),
      (16#2139#,16#2139#,LL),(16#213A#,16#213B#,SO),(16#213C#,16#213D#,LL),
      (16#213E#,16#213F#,LU),(16#2140#,16#2144#,SM),(16#2145#,16#2145#,LU),
      (16#2146#,16#2149#,LL),(16#214A#,16#214A#,SO),(16#214B#,16#214B#,SM),
      (16#214C#,16#214D#,SO),(16#214E#,16#214E#,LL),(16#214F#,16#214F#,SO),
      (16#2150#,16#215F#,NO),(16#2160#,16#2182#,NL),(16#2183#,16#2183#,LU),
      (16#2184#,16#2184#,LL),(16#2185#,16#2188#,NL),(16#2189#,16#2189#,NO),
      (16#218A#,16#218B#,SO),(16#2190#,16#2194#,SM),(16#2195#,16#2199#,SO),
      (16#219A#,16#219B#,SM),(16#219C#,16#219F#,SO),(16#21A0#,16#21A0#,SM),
      (16#21A1#,16#21A2#,SO),(16#21A3#,16#21A3#,SM),(16#21A4#,16#21A5#,SO),
      (16#21A6#,16#21A6#,SM),(16#21A7#,16#21AD#,SO),(16#21AE#,16#21AE#,SM),
      (16#21AF#,16#21CD#,SO),(16#21CE#,16#21CF#,SM),(16#21D0#,16#21D1#,SO),
      (16#21D2#,16#21D2#,SM),(16#21D3#,16#21D3#,SO),(16#21D4#,16#21D4#,SM),
      (16#21D5#,16#21F3#,SO),(16#21F4#,16#22FF#,SM),(16#2300#,16#2307#,SO),
      (16#2308#,16#2308#,PS),(16#2309#,16#2309#,PE),(16#230A#,16#230A#,PS),
      (16#230B#,16#230B#,PE),(16#230C#,16#231F#,SO),(16#2320#,16#2321#,SM),
      (16#2322#,16#2328#,SO),(16#2329#,16#2329#,PS),(16#232A#,16#232A#,PE),
      (16#232B#,16#237B#,SO),(16#237C#,16#237C#,SM),(16#237D#,16#239A#,SO),
      (16#239B#,16#23B3#,SM),(16#23B4#,16#23DB#,SO),(16#23DC#,16#23E1#,SM),
      (16#23E2#,16#2426#,SO),(16#2440#,16#244A#,SO),(16#2460#,16#249B#,NO),
      (16#249C#,16#24E9#,SO),(16#24EA#,16#24FF#,NO),(16#2500#,16#25B6#,SO),
      (16#25B7#,16#25B7#,SM),(16#25B8#,16#25C0#,SO),(16#25C1#,16#25C1#,SM),
      (16#25C2#,16#25F7#,SO),(16#25F8#,16#25FF#,SM),(16#2600#,16#266E#,SO),
      (16#266F#,16#266F#,SM),(16#2670#,16#2767#,SO),(16#2768#,16#2768#,PS),
      (16#2769#,16#2769#,PE),(16#276A#,16#276A#,PS),(16#276B#,16#276B#,PE),
      (16#276C#,16#276C#,PS),(16#276D#,16#276D#,PE),(16#276E#,16#276E#,PS),
      (16#276F#,16#276F#,PE),(16#2770#,16#2770#,PS),(16#2771#,16#2771#,PE),
      (16#2772#,16#2772#,PS),(16#2773#,16#2773#,PE),(16#2774#,16#2774#,PS),
      (16#2775#,16#2775#,PE),(16#2776#,16#2793#,NO),(16#2794#,16#27BF#,SO),
      (16#27C0#,16#27C4#,SM),(16#27C5#,16#27C5#,PS),(16#27C6#,16#27C6#,PE),
      (16#27C7#,16#27E5#,SM),(16#27E6#,16#27E6#,PS),(16#27E7#,16#27E7#,PE),
      (16#27E8#,16#27E8#,PS),(16#27E9#,16#27E9#,PE),(16#27EA#,16#27EA#,PS),
      (16#27EB#,16#27EB#,PE),(16#27EC#,16#27EC#,PS),(16#27ED#,16#27ED#,PE),
      (16#27EE#,16#27EE#,PS),(16#27EF#,16#27EF#,PE),(16#27F0#,16#27FF#,SM),
      (16#2800#,16#28FF#,SO),(16#2900#,16#2982#,SM),(16#2983#,16#2983#,PS),
      (16#2984#,16#2984#,PE),(16#2985#,16#2985#,PS),(16#2986#,16#2986#,PE),
      (16#2987#,16#2987#,PS),(16#2988#,16#2988#,PE),(16#2989#,16#2989#,PS),
      (16#298A#,16#298A#,PE),(16#298B#,16#298B#,PS),(16#298C#,16#298C#,PE),
      (16#298D#,16#298D#,PS),(16#298E#,16#298E#,PE),(16#298F#,16#298F#,PS),
      (16#2990#,16#2990#,PE),(16#2991#,16#2991#,PS),(16#2992#,16#2992#,PE),
      (16#2993#,16#2993#,PS),(16#2994#,16#2994#,PE),(16#2995#,16#2995#,PS),
      (16#2996#,16#2996#,PE),(16#2997#,16#2997#,PS),(16#2998#,16#2998#,PE),
      (16#2999#,16#29D7#,SM),(16#29D8#,16#29D8#,PS),(16#29D9#,16#29D9#,PE),
      (16#29DA#,16#29DA#,PS),(16#29DB#,16#29DB#,PE),(16#29DC#,16#29FB#,SM),
      (16#29FC#,16#29FC#,PS),(16#29FD#,16#29FD#,PE),(16#29FE#,16#2AFF#,SM),
      (16#2B00#,16#2B2F#,SO),(16#2B30#,16#2B44#,SM),(16#2B45#,16#2B46#,SO),
      (16#2B47#,16#2B4C#,SM),(16#2B4D#,16#2B73#,SO),(16#2B76#,16#2B95#,SO),
      (16#2B97#,16#2BFF#,SO),(16#2C00#,16#2C2F#,LU),(16#2C30#,16#2C5F#,LL),
      (16#2C60#,16#2C60#,LU),(16#2C61#,16#2C61#,LL),(16#2C62#,16#2C64#,LU),
      (16#2C65#,16#2C66#,LL),(16#2C67#,16#2C67#,LU),(16#2C68#,16#2C68#,LL),
      (16#2C69#,16#2C69#,LU),(16#2C6A#,16#2C6A#,LL),(16#2C6B#,16#2C6B#,LU),
      (16#2C6C#,16#2C6C#,LL),(16#2C6D#,16#2C70#,LU),(16#2C71#,16#2C71#,LL),
      (16#2C72#,16#2C72#,LU),(16#2C73#,16#2C74#,LL),(16#2C75#,16#2C75#,LU),
      (16#2C76#,16#2C7B#,LL),(16#2C7C#,16#2C7D#,LM),(16#2C7E#,16#2C80#,LU),
      (16#2C81#,16#2C81#,LL),(16#2C82#,16#2C82#,LU),(16#2C83#,16#2C83#,LL),
      (16#2C84#,16#2C84#,LU),(16#2C85#,16#2C85#,LL),(16#2C86#,16#2C86#,LU),
      (16#2C87#,16#2C87#,LL),(16#2C88#,16#2C88#,LU),(16#2C89#,16#2C89#,LL),
      (16#2C8A#,16#2C8A#,LU),(16#2C8B#,16#2C8B#,LL),(16#2C8C#,16#2C8C#,LU),
      (16#2C8D#,16#2C8D#,LL),(16#2C8E#,16#2C8E#,LU),(16#2C8F#,16#2C8F#,LL),
      (16#2C90#,16#2C90#,LU),(16#2C91#,16#2C91#,LL),(16#2C92#,16#2C92#,LU),
      (16#2C93#,16#2C93#,LL),(16#2C94#,16#2C94#,LU),(16#2C95#,16#2C95#,LL),
      (16#2C96#,16#2C96#,LU),(16#2C97#,16#2C97#,LL),(16#2C98#,16#2C98#,LU),
      (16#2C99#,16#2C99#,LL),(16#2C9A#,16#2C9A#,LU),(16#2C9B#,16#2C9B#,LL),
      (16#2C9C#,16#2C9C#,LU),(16#2C9D#,16#2C9D#,LL),(16#2C9E#,16#2C9E#,LU),
      (16#2C9F#,16#2C9F#,LL),(16#2CA0#,16#2CA0#,LU),(16#2CA1#,16#2CA1#,LL),
      (16#2CA2#,16#2CA2#,LU),(16#2CA3#,16#2CA3#,LL),(16#2CA4#,16#2CA4#,LU),
      (16#2CA5#,16#2CA5#,LL),(16#2CA6#,16#2CA6#,LU),(16#2CA7#,16#2CA7#,LL),
      (16#2CA8#,16#2CA8#,LU),(16#2CA9#,16#2CA9#,LL),(16#2CAA#,16#2CAA#,LU),
      (16#2CAB#,16#2CAB#,LL),(16#2CAC#,16#2CAC#,LU),(16#2CAD#,16#2CAD#,LL),
      (16#2CAE#,16#2CAE#,LU),(16#2CAF#,16#2CAF#,LL),(16#2CB0#,16#2CB0#,LU),
      (16#2CB1#,16#2CB1#,LL),(16#2CB2#,16#2CB2#,LU),(16#2CB3#,16#2CB3#,LL),
      (16#2CB4#,16#2CB4#,LU),(16#2CB5#,16#2CB5#,LL),(16#2CB6#,16#2CB6#,LU),
      (16#2CB7#,16#2CB7#,LL),(16#2CB8#,16#2CB8#,LU),(16#2CB9#,16#2CB9#,LL),
      (16#2CBA#,16#2CBA#,LU),(16#2CBB#,16#2CBB#,LL),(16#2CBC#,16#2CBC#,LU),
      (16#2CBD#,16#2CBD#,LL),(16#2CBE#,16#2CBE#,LU),(16#2CBF#,16#2CBF#,LL),
      (16#2CC0#,16#2CC0#,LU),(16#2CC1#,16#2CC1#,LL),(16#2CC2#,16#2CC2#,LU),
      (16#2CC3#,16#2CC3#,LL),(16#2CC4#,16#2CC4#,LU),(16#2CC5#,16#2CC5#,LL),
      (16#2CC6#,16#2CC6#,LU),(16#2CC7#,16#2CC7#,LL),(16#2CC8#,16#2CC8#,LU),
      (16#2CC9#,16#2CC9#,LL),(16#2CCA#,16#2CCA#,LU),(16#2CCB#,16#2CCB#,LL),
      (16#2CCC#,16#2CCC#,LU),(16#2CCD#,16#2CCD#,LL),(16#2CCE#,16#2CCE#,LU),
      (16#2CCF#,16#2CCF#,LL),(16#2CD0#,16#2CD0#,LU),(16#2CD1#,16#2CD1#,LL),
      (16#2CD2#,16#2CD2#,LU),(16#2CD3#,16#2CD3#,LL),(16#2CD4#,16#2CD4#,LU),
      (16#2CD5#,16#2CD5#,LL),(16#2CD6#,16#2CD6#,LU),(16#2CD7#,16#2CD7#,LL),
      (16#2CD8#,16#2CD8#,LU),(16#2CD9#,16#2CD9#,LL),(16#2CDA#,16#2CDA#,LU),
      (16#2CDB#,16#2CDB#,LL),(16#2CDC#,16#2CDC#,LU),(16#2CDD#,16#2CDD#,LL),
      (16#2CDE#,16#2CDE#,LU),(16#2CDF#,16#2CDF#,LL),(16#2CE0#,16#2CE0#,LU),
      (16#2CE1#,16#2CE1#,LL),(16#2CE2#,16#2CE2#,LU),(16#2CE3#,16#2CE4#,LL),
      (16#2CE5#,16#2CEA#,SO),(16#2CEB#,16#2CEB#,LU),(16#2CEC#,16#2CEC#,LL),
      (16#2CED#,16#2CED#,LU),(16#2CEE#,16#2CEE#,LL),(16#2CEF#,16#2CF1#,MN),
      (16#2CF2#,16#2CF2#,LU),(16#2CF3#,16#2CF3#,LL),(16#2CF9#,16#2CFC#,PO),
      (16#2CFD#,16#2CFD#,NO),(16#2CFE#,16#2CFF#,PO),(16#2D00#,16#2D25#,LL),
      (16#2D27#,16#2D27#,LL),(16#2D2D#,16#2D2D#,LL),(16#2D30#,16#2D67#,LO),
      (16#2D6F#,16#2D6F#,LM),(16#2D70#,16#2D70#,PO),(16#2D7F#,16#2D7F#,MN),
      (16#2D80#,16#2D96#,LO),(16#2DA0#,16#2DA6#,LO),(16#2DA8#,16#2DAE#,LO),
      (16#2DB0#,16#2DB6#,LO),(16#2DB8#,16#2DBE#,LO),(16#2DC0#,16#2DC6#,LO),
      (16#2DC8#,16#2DCE#,LO),(16#2DD0#,16#2DD6#,LO),(16#2DD8#,16#2DDE#,LO),
      (16#2DE0#,16#2DFF#,MN),(16#2E00#,16#2E01#,PO),(16#2E02#,16#2E02#,PI),
      (16#2E03#,16#2E03#,PF),(16#2E04#,16#2E04#,PI),(16#2E05#,16#2E05#,PF),
      (16#2E06#,16#2E08#,PO),(16#2E09#,16#2E09#,PI),(16#2E0A#,16#2E0A#,PF),
      (16#2E0B#,16#2E0B#,PO),(16#2E0C#,16#2E0C#,PI),(16#2E0D#,16#2E0D#,PF),
      (16#2E0E#,16#2E16#,PO),(16#2E17#,16#2E17#,PD),(16#2E18#,16#2E19#,PO),
      (16#2E1A#,16#2E1A#,PD),(16#2E1B#,16#2E1B#,PO),(16#2E1C#,16#2E1C#,PI),
      (16#2E1D#,16#2E1D#,PF),(16#2E1E#,16#2E1F#,PO),(16#2E20#,16#2E20#,PI),
      (16#2E21#,16#2E21#,PF),(16#2E22#,16#2E22#,PS),(16#2E23#,16#2E23#,PE),
      (16#2E24#,16#2E24#,PS),(16#2E25#,16#2E25#,PE),(16#2E26#,16#2E26#,PS),
      (16#2E27#,16#2E27#,PE),(16#2E28#,16#2E28#,PS),(16#2E29#,16#2E29#,PE),
      (16#2E2A#,16#2E2E#,PO),(16#2E2F#,16#2E2F#,LM),(16#2E30#,16#2E39#,PO),
      (16#2E3A#,16#2E3B#,PD),(16#2E3C#,16#2E3F#,PO),(16#2E40#,16#2E40#,PD),
      (16#2E41#,16#2E41#,PO),(16#2E42#,16#2E42#,PS),(16#2E43#,16#2E4F#,PO),
      (16#2E50#,16#2E51#,SO),(16#2E52#,16#2E54#,PO),(16#2E55#,16#2E55#,PS),
      (16#2E56#,16#2E56#,PE),(16#2E57#,16#2E57#,PS),(16#2E58#,16#2E58#,PE),
      (16#2E59#,16#2E59#,PS),(16#2E5A#,16#2E5A#,PE),(16#2E5B#,16#2E5B#,PS),
      (16#2E5C#,16#2E5C#,PE),(16#2E5D#,16#2E5D#,PD),(16#2E80#,16#2E99#,SO),
      (16#2E9B#,16#2EF3#,SO),(16#2F00#,16#2FD5#,SO),(16#2FF0#,16#2FFB#,SO),
      (16#3000#,16#3000#,ZS),(16#3001#,16#3003#,PO),(16#3004#,16#3004#,SO),
      (16#3005#,16#3005#,LM),(16#3006#,16#3006#,LO),(16#3007#,16#3007#,NL),
      (16#3008#,16#3008#,PS),(16#3009#,16#3009#,PE),(16#300A#,16#300A#,PS),
      (16#300B#,16#300B#,PE),(16#300C#,16#300C#,PS),(16#300D#,16#300D#,PE),
      (16#300E#,16#300E#,PS),(16#300F#,16#300F#,PE),(16#3010#,16#3010#,PS),
      (16#3011#,16#3011#,PE),(16#3012#,16#3013#,SO),(16#3014#,16#3014#,PS),
      (16#3015#,16#3015#,PE),(16#3016#,16#3016#,PS),(16#3017#,16#3017#,PE),
      (16#3018#,16#3018#,PS),(16#3019#,16#3019#,PE),(16#301A#,16#301A#,PS),
      (16#301B#,16#301B#,PE),(16#301C#,16#301C#,PD),(16#301D#,16#301D#,PS),
      (16#301E#,16#301F#,PE),(16#3020#,16#3020#,SO),(16#3021#,16#3029#,NL),
      (16#302A#,16#302D#,MN),(16#302E#,16#302F#,MC),(16#3030#,16#3030#,PD),
      (16#3031#,16#3035#,LM),(16#3036#,16#3037#,SO),(16#3038#,16#303A#,NL),
      (16#303B#,16#303B#,LM),(16#303C#,16#303C#,LO),(16#303D#,16#303D#,PO),
      (16#303E#,16#303F#,SO),(16#3041#,16#3096#,LO),(16#3099#,16#309A#,MN),
      (16#309B#,16#309C#,SK),(16#309D#,16#309E#,LM),(16#309F#,16#309F#,LO),
      (16#30A0#,16#30A0#,PD),(16#30A1#,16#30FA#,LO),(16#30FB#,16#30FB#,PO),
      (16#30FC#,16#30FE#,LM),(16#30FF#,16#30FF#,LO),(16#3105#,16#312F#,LO),
      (16#3131#,16#318E#,LO),(16#3190#,16#3191#,SO),(16#3192#,16#3195#,NO),
      (16#3196#,16#319F#,SO),(16#31A0#,16#31BF#,LO),(16#31C0#,16#31E3#,SO),
      (16#31F0#,16#31FF#,LO),(16#3200#,16#321E#,SO),(16#3220#,16#3229#,NO),
      (16#322A#,16#3247#,SO),(16#3248#,16#324F#,NO),(16#3250#,16#3250#,SO),
      (16#3251#,16#325F#,NO),(16#3260#,16#327F#,SO),(16#3280#,16#3289#,NO),
      (16#328A#,16#32B0#,SO),(16#32B1#,16#32BF#,NO),(16#32C0#,16#33FF#,SO),
      (16#3400#,16#3400#,LO),(16#4DBF#,16#4DBF#,LO),(16#4DC0#,16#4DFF#,SO),
      (16#4E00#,16#4E00#,LO),(16#9FFF#,16#A014#,LO),(16#A015#,16#A015#,LM),
      (16#A016#,16#A48C#,LO),(16#A490#,16#A4C6#,SO),(16#A4D0#,16#A4F7#,LO),
      (16#A4F8#,16#A4FD#,LM),(16#A4FE#,16#A4FF#,PO),(16#A500#,16#A60B#,LO),
      (16#A60C#,16#A60C#,LM),(16#A60D#,16#A60F#,PO),(16#A610#,16#A61F#,LO),
      (16#A620#,16#A629#,ND),(16#A62A#,16#A62B#,LO),(16#A640#,16#A640#,LU),
      (16#A641#,16#A641#,LL),(16#A642#,16#A642#,LU),(16#A643#,16#A643#,LL),
      (16#A644#,16#A644#,LU),(16#A645#,16#A645#,LL),(16#A646#,16#A646#,LU),
      (16#A647#,16#A647#,LL),(16#A648#,16#A648#,LU),(16#A649#,16#A649#,LL),
      (16#A64A#,16#A64A#,LU),(16#A64B#,16#A64B#,LL),(16#A64C#,16#A64C#,LU),
      (16#A64D#,16#A64D#,LL),(16#A64E#,16#A64E#,LU),(16#A64F#,16#A64F#,LL),
      (16#A650#,16#A650#,LU),(16#A651#,16#A651#,LL),(16#A652#,16#A652#,LU),
      (16#A653#,16#A653#,LL),(16#A654#,16#A654#,LU),(16#A655#,16#A655#,LL),
      (16#A656#,16#A656#,LU),(16#A657#,16#A657#,LL),(16#A658#,16#A658#,LU),
      (16#A659#,16#A659#,LL),(16#A65A#,16#A65A#,LU),(16#A65B#,16#A65B#,LL),
      (16#A65C#,16#A65C#,LU),(16#A65D#,16#A65D#,LL),(16#A65E#,16#A65E#,LU),
      (16#A65F#,16#A65F#,LL),(16#A660#,16#A660#,LU),(16#A661#,16#A661#,LL),
      (16#A662#,16#A662#,LU),(16#A663#,16#A663#,LL),(16#A664#,16#A664#,LU),
      (16#A665#,16#A665#,LL),(16#A666#,16#A666#,LU),(16#A667#,16#A667#,LL),
      (16#A668#,16#A668#,LU),(16#A669#,16#A669#,LL),(16#A66A#,16#A66A#,LU),
      (16#A66B#,16#A66B#,LL),(16#A66C#,16#A66C#,LU),(16#A66D#,16#A66D#,LL),
      (16#A66E#,16#A66E#,LO),(16#A66F#,16#A66F#,MN),(16#A670#,16#A672#,ME),
      (16#A673#,16#A673#,PO),(16#A674#,16#A67D#,MN),(16#A67E#,16#A67E#,PO),
      (16#A67F#,16#A67F#,LM),(16#A680#,16#A680#,LU),(16#A681#,16#A681#,LL),
      (16#A682#,16#A682#,LU),(16#A683#,16#A683#,LL),(16#A684#,16#A684#,LU),
      (16#A685#,16#A685#,LL),(16#A686#,16#A686#,LU),(16#A687#,16#A687#,LL),
      (16#A688#,16#A688#,LU),(16#A689#,16#A689#,LL),(16#A68A#,16#A68A#,LU),
      (16#A68B#,16#A68B#,LL),(16#A68C#,16#A68C#,LU),(16#A68D#,16#A68D#,LL),
      (16#A68E#,16#A68E#,LU),(16#A68F#,16#A68F#,LL),(16#A690#,16#A690#,LU),
      (16#A691#,16#A691#,LL),(16#A692#,16#A692#,LU),(16#A693#,16#A693#,LL),
      (16#A694#,16#A694#,LU),(16#A695#,16#A695#,LL),(16#A696#,16#A696#,LU),
      (16#A697#,16#A697#,LL),(16#A698#,16#A698#,LU),(16#A699#,16#A699#,LL),
      (16#A69A#,16#A69A#,LU),(16#A69B#,16#A69B#,LL),(16#A69C#,16#A69D#,LM),
      (16#A69E#,16#A69F#,MN),(16#A6A0#,16#A6E5#,LO),(16#A6E6#,16#A6EF#,NL),
      (16#A6F0#,16#A6F1#,MN),(16#A6F2#,16#A6F7#,PO),(16#A700#,16#A716#,SK),
      (16#A717#,16#A71F#,LM),(16#A720#,16#A721#,SK),(16#A722#,16#A722#,LU),
      (16#A723#,16#A723#,LL),(16#A724#,16#A724#,LU),(16#A725#,16#A725#,LL),
      (16#A726#,16#A726#,LU),(16#A727#,16#A727#,LL),(16#A728#,16#A728#,LU),
      (16#A729#,16#A729#,LL),(16#A72A#,16#A72A#,LU),(16#A72B#,16#A72B#,LL),
      (16#A72C#,16#A72C#,LU),(16#A72D#,16#A72D#,LL),(16#A72E#,16#A72E#,LU),
      (16#A72F#,16#A731#,LL),(16#A732#,16#A732#,LU),(16#A733#,16#A733#,LL),
      (16#A734#,16#A734#,LU),(16#A735#,16#A735#,LL),(16#A736#,16#A736#,LU),
      (16#A737#,16#A737#,LL),(16#A738#,16#A738#,LU),(16#A739#,16#A739#,LL),
      (16#A73A#,16#A73A#,LU),(16#A73B#,16#A73B#,LL),(16#A73C#,16#A73C#,LU),
      (16#A73D#,16#A73D#,LL),(16#A73E#,16#A73E#,LU),(16#A73F#,16#A73F#,LL),
      (16#A740#,16#A740#,LU),(16#A741#,16#A741#,LL),(16#A742#,16#A742#,LU),
      (16#A743#,16#A743#,LL),(16#A744#,16#A744#,LU),(16#A745#,16#A745#,LL),
      (16#A746#,16#A746#,LU),(16#A747#,16#A747#,LL),(16#A748#,16#A748#,LU),
      (16#A749#,16#A749#,LL),(16#A74A#,16#A74A#,LU),(16#A74B#,16#A74B#,LL),
      (16#A74C#,16#A74C#,LU),(16#A74D#,16#A74D#,LL),(16#A74E#,16#A74E#,LU),
      (16#A74F#,16#A74F#,LL),(16#A750#,16#A750#,LU),(16#A751#,16#A751#,LL),
      (16#A752#,16#A752#,LU),(16#A753#,16#A753#,LL),(16#A754#,16#A754#,LU),
      (16#A755#,16#A755#,LL),(16#A756#,16#A756#,LU),(16#A757#,16#A757#,LL),
      (16#A758#,16#A758#,LU),(16#A759#,16#A759#,LL),(16#A75A#,16#A75A#,LU),
      (16#A75B#,16#A75B#,LL),(16#A75C#,16#A75C#,LU),(16#A75D#,16#A75D#,LL),
      (16#A75E#,16#A75E#,LU),(16#A75F#,16#A75F#,LL),(16#A760#,16#A760#,LU),
      (16#A761#,16#A761#,LL),(16#A762#,16#A762#,LU),(16#A763#,16#A763#,LL),
      (16#A764#,16#A764#,LU),(16#A765#,16#A765#,LL),(16#A766#,16#A766#,LU),
      (16#A767#,16#A767#,LL),(16#A768#,16#A768#,LU),(16#A769#,16#A769#,LL),
      (16#A76A#,16#A76A#,LU),(16#A76B#,16#A76B#,LL),(16#A76C#,16#A76C#,LU),
      (16#A76D#,16#A76D#,LL),(16#A76E#,16#A76E#,LU),(16#A76F#,16#A76F#,LL),
      (16#A770#,16#A770#,LM),(16#A771#,16#A778#,LL),(16#A779#,16#A779#,LU),
      (16#A77A#,16#A77A#,LL),(16#A77B#,16#A77B#,LU),(16#A77C#,16#A77C#,LL),
      (16#A77D#,16#A77E#,LU),(16#A77F#,16#A77F#,LL),(16#A780#,16#A780#,LU),
      (16#A781#,16#A781#,LL),(16#A782#,16#A782#,LU),(16#A783#,16#A783#,LL),
      (16#A784#,16#A784#,LU),(16#A785#,16#A785#,LL),(16#A786#,16#A786#,LU),
      (16#A787#,16#A787#,LL),(16#A788#,16#A788#,LM),(16#A789#,16#A78A#,SK),
      (16#A78B#,16#A78B#,LU),(16#A78C#,16#A78C#,LL),(16#A78D#,16#A78D#,LU),
      (16#A78E#,16#A78E#,LL),(16#A78F#,16#A78F#,LO),(16#A790#,16#A790#,LU),
      (16#A791#,16#A791#,LL),(16#A792#,16#A792#,LU),(16#A793#,16#A795#,LL),
      (16#A796#,16#A796#,LU),(16#A797#,16#A797#,LL),(16#A798#,16#A798#,LU),
      (16#A799#,16#A799#,LL),(16#A79A#,16#A79A#,LU),(16#A79B#,16#A79B#,LL),
      (16#A79C#,16#A79C#,LU),(16#A79D#,16#A79D#,LL),(16#A79E#,16#A79E#,LU),
      (16#A79F#,16#A79F#,LL),(16#A7A0#,16#A7A0#,LU),(16#A7A1#,16#A7A1#,LL),
      (16#A7A2#,16#A7A2#,LU),(16#A7A3#,16#A7A3#,LL),(16#A7A4#,16#A7A4#,LU),
      (16#A7A5#,16#A7A5#,LL),(16#A7A6#,16#A7A6#,LU),(16#A7A7#,16#A7A7#,LL),
      (16#A7A8#,16#A7A8#,LU),(16#A7A9#,16#A7A9#,LL),(16#A7AA#,16#A7AE#,LU),
      (16#A7AF#,16#A7AF#,LL),(16#A7B0#,16#A7B4#,LU),(16#A7B5#,16#A7B5#,LL),
      (16#A7B6#,16#A7B6#,LU),(16#A7B7#,16#A7B7#,LL),(16#A7B8#,16#A7B8#,LU),
      (16#A7B9#,16#A7B9#,LL),(16#A7BA#,16#A7BA#,LU),(16#A7BB#,16#A7BB#,LL),
      (16#A7BC#,16#A7BC#,LU),(16#A7BD#,16#A7BD#,LL),(16#A7BE#,16#A7BE#,LU),
      (16#A7BF#,16#A7BF#,LL),(16#A7C0#,16#A7C0#,LU),(16#A7C1#,16#A7C1#,LL),
      (16#A7C2#,16#A7C2#,LU),(16#A7C3#,16#A7C3#,LL),(16#A7C4#,16#A7C7#,LU),
      (16#A7C8#,16#A7C8#,LL),(16#A7C9#,16#A7C9#,LU),(16#A7CA#,16#A7CA#,LL),
      (16#A7D0#,16#A7D0#,LU),(16#A7D1#,16#A7D1#,LL),(16#A7D3#,16#A7D3#,LL),
      (16#A7D5#,16#A7D5#,LL),(16#A7D6#,16#A7D6#,LU),(16#A7D7#,16#A7D7#,LL),
      (16#A7D8#,16#A7D8#,LU),(16#A7D9#,16#A7D9#,LL),(16#A7F2#,16#A7F4#,LM),
      (16#A7F5#,16#A7F5#,LU),(16#A7F6#,16#A7F6#,LL),(16#A7F7#,16#A7F7#,LO),
      (16#A7F8#,16#A7F9#,LM),(16#A7FA#,16#A7FA#,LL),(16#A7FB#,16#A801#,LO),
      (16#A802#,16#A802#,MN),(16#A803#,16#A805#,LO),(16#A806#,16#A806#,MN),
      (16#A807#,16#A80A#,LO),(16#A80B#,16#A80B#,MN),(16#A80C#,16#A822#,LO),
      (16#A823#,16#A824#,MC),(16#A825#,16#A826#,MN),(16#A827#,16#A827#,MC),
      (16#A828#,16#A82B#,SO),(16#A82C#,16#A82C#,MN),(16#A830#,16#A835#,NO),
      (16#A836#,16#A837#,SO),(16#A838#,16#A838#,SC),(16#A839#,16#A839#,SO),
      (16#A840#,16#A873#,LO),(16#A874#,16#A877#,PO),(16#A880#,16#A881#,MC),
      (16#A882#,16#A8B3#,LO),(16#A8B4#,16#A8C3#,MC),(16#A8C4#,16#A8C5#,MN),
      (16#A8CE#,16#A8CF#,PO),(16#A8D0#,16#A8D9#,ND),(16#A8E0#,16#A8F1#,MN),
      (16#A8F2#,16#A8F7#,LO),(16#A8F8#,16#A8FA#,PO),(16#A8FB#,16#A8FB#,LO),
      (16#A8FC#,16#A8FC#,PO),(16#A8FD#,16#A8FE#,LO),(16#A8FF#,16#A8FF#,MN),
      (16#A900#,16#A909#,ND),(16#A90A#,16#A925#,LO),(16#A926#,16#A92D#,MN),
      (16#A92E#,16#A92F#,PO),(16#A930#,16#A946#,LO),(16#A947#,16#A951#,MN),
      (16#A952#,16#A953#,MC),(16#A95F#,16#A95F#,PO),(16#A960#,16#A97C#,LO),
      (16#A980#,16#A982#,MN),(16#A983#,16#A983#,MC),(16#A984#,16#A9B2#,LO),
      (16#A9B3#,16#A9B3#,MN),(16#A9B4#,16#A9B5#,MC),(16#A9B6#,16#A9B9#,MN),
      (16#A9BA#,16#A9BB#,MC),(16#A9BC#,16#A9BD#,MN),(16#A9BE#,16#A9C0#,MC),
      (16#A9C1#,16#A9CD#,PO),(16#A9CF#,16#A9CF#,LM),(16#A9D0#,16#A9D9#,ND),
      (16#A9DE#,16#A9DF#,PO),(16#A9E0#,16#A9E4#,LO),(16#A9E5#,16#A9E5#,MN),
      (16#A9E6#,16#A9E6#,LM),(16#A9E7#,16#A9EF#,LO),(16#A9F0#,16#A9F9#,ND),
      (16#A9FA#,16#A9FE#,LO),(16#AA00#,16#AA28#,LO),(16#AA29#,16#AA2E#,MN),
      (16#AA2F#,16#AA30#,MC),(16#AA31#,16#AA32#,MN),(16#AA33#,16#AA34#,MC),
      (16#AA35#,16#AA36#,MN),(16#AA40#,16#AA42#,LO),(16#AA43#,16#AA43#,MN),
      (16#AA44#,16#AA4B#,LO),(16#AA4C#,16#AA4C#,MN),(16#AA4D#,16#AA4D#,MC),
      (16#AA50#,16#AA59#,ND),(16#AA5C#,16#AA5F#,PO),(16#AA60#,16#AA6F#,LO),
      (16#AA70#,16#AA70#,LM),(16#AA71#,16#AA76#,LO),(16#AA77#,16#AA79#,SO),
      (16#AA7A#,16#AA7A#,LO),(16#AA7B#,16#AA7B#,MC),(16#AA7C#,16#AA7C#,MN),
      (16#AA7D#,16#AA7D#,MC),(16#AA7E#,16#AAAF#,LO),(16#AAB0#,16#AAB0#,MN),
      (16#AAB1#,16#AAB1#,LO),(16#AAB2#,16#AAB4#,MN),(16#AAB5#,16#AAB6#,LO),
      (16#AAB7#,16#AAB8#,MN),(16#AAB9#,16#AABD#,LO),(16#AABE#,16#AABF#,MN),
      (16#AAC0#,16#AAC0#,LO),(16#AAC1#,16#AAC1#,MN),(16#AAC2#,16#AAC2#,LO),
      (16#AADB#,16#AADC#,LO),(16#AADD#,16#AADD#,LM),(16#AADE#,16#AADF#,PO),
      (16#AAE0#,16#AAEA#,LO),(16#AAEB#,16#AAEB#,MC),(16#AAEC#,16#AAED#,MN),
      (16#AAEE#,16#AAEF#,MC),(16#AAF0#,16#AAF1#,PO),(16#AAF2#,16#AAF2#,LO),
      (16#AAF3#,16#AAF4#,LM),(16#AAF5#,16#AAF5#,MC),(16#AAF6#,16#AAF6#,MN),
      (16#AB01#,16#AB06#,LO),(16#AB09#,16#AB0E#,LO),(16#AB11#,16#AB16#,LO),
      (16#AB20#,16#AB26#,LO),(16#AB28#,16#AB2E#,LO),(16#AB30#,16#AB5A#,LL),
      (16#AB5B#,16#AB5B#,SK),(16#AB5C#,16#AB5F#,LM),(16#AB60#,16#AB68#,LL),
      (16#AB69#,16#AB69#,LM),(16#AB6A#,16#AB6B#,SK),(16#AB70#,16#ABBF#,LL),
      (16#ABC0#,16#ABE2#,LO),(16#ABE3#,16#ABE4#,MC),(16#ABE5#,16#ABE5#,MN),
      (16#ABE6#,16#ABE7#,MC),(16#ABE8#,16#ABE8#,MN),(16#ABE9#,16#ABEA#,MC),
      (16#ABEB#,16#ABEB#,PO),(16#ABEC#,16#ABEC#,MC),(16#ABED#,16#ABED#,MN),
      (16#ABF0#,16#ABF9#,ND),(16#AC00#,16#AC00#,LO),(16#D7A3#,16#D7A3#,LO),
      (16#D7B0#,16#D7C6#,LO),(16#D7CB#,16#D7FB#,LO),(16#D800#,16#D800#,CS),
      (16#DB7F#,16#DB80#,CS),(16#DBFF#,16#DC00#,CS),(16#DFFF#,16#DFFF#,CS),
      (16#E000#,16#E000#,CO),(16#F8FF#,16#F8FF#,CO),(16#F900#,16#FA6D#,LO),
      (16#FA70#,16#FAD9#,LO),(16#FB00#,16#FB06#,LL),(16#FB13#,16#FB17#,LL),
      (16#FB1D#,16#FB1D#,LO),(16#FB1E#,16#FB1E#,MN),(16#FB1F#,16#FB28#,LO),
      (16#FB29#,16#FB29#,SM),(16#FB2A#,16#FB36#,LO),(16#FB38#,16#FB3C#,LO),
      (16#FB3E#,16#FB3E#,LO),(16#FB40#,16#FB41#,LO),(16#FB43#,16#FB44#,LO),
      (16#FB46#,16#FBB1#,LO),(16#FBB2#,16#FBC2#,SK),(16#FBD3#,16#FD3D#,LO),
      (16#FD3E#,16#FD3E#,PE),(16#FD3F#,16#FD3F#,PS),(16#FD40#,16#FD4F#,SO),
      (16#FD50#,16#FD8F#,LO),(16#FD92#,16#FDC7#,LO),(16#FDCF#,16#FDCF#,SO),
      (16#FDF0#,16#FDFB#,LO),(16#FDFC#,16#FDFC#,SC),(16#FDFD#,16#FDFF#,SO),
      (16#FE00#,16#FE0F#,MN),(16#FE10#,16#FE16#,PO),(16#FE17#,16#FE17#,PS),
      (16#FE18#,16#FE18#,PE),(16#FE19#,16#FE19#,PO),(16#FE20#,16#FE2F#,MN),
      (16#FE30#,16#FE30#,PO),(16#FE31#,16#FE32#,PD),(16#FE33#,16#FE34#,PC),
      (16#FE35#,16#FE35#,PS),(16#FE36#,16#FE36#,PE),(16#FE37#,16#FE37#,PS),
      (16#FE38#,16#FE38#,PE),(16#FE39#,16#FE39#,PS),(16#FE3A#,16#FE3A#,PE),
      (16#FE3B#,16#FE3B#,PS),(16#FE3C#,16#FE3C#,PE),(16#FE3D#,16#FE3D#,PS),
      (16#FE3E#,16#FE3E#,PE),(16#FE3F#,16#FE3F#,PS),(16#FE40#,16#FE40#,PE),
      (16#FE41#,16#FE41#,PS),(16#FE42#,16#FE42#,PE),(16#FE43#,16#FE43#,PS),
      (16#FE44#,16#FE44#,PE),(16#FE45#,16#FE46#,PO),(16#FE47#,16#FE47#,PS),
      (16#FE48#,16#FE48#,PE),(16#FE49#,16#FE4C#,PO),(16#FE4D#,16#FE4F#,PC),
      (16#FE50#,16#FE52#,PO),(16#FE54#,16#FE57#,PO),(16#FE58#,16#FE58#,PD),
      (16#FE59#,16#FE59#,PS),(16#FE5A#,16#FE5A#,PE),(16#FE5B#,16#FE5B#,PS),
      (16#FE5C#,16#FE5C#,PE),(16#FE5D#,16#FE5D#,PS),(16#FE5E#,16#FE5E#,PE),
      (16#FE5F#,16#FE61#,PO),(16#FE62#,16#FE62#,SM),(16#FE63#,16#FE63#,PD),
      (16#FE64#,16#FE66#,SM),(16#FE68#,16#FE68#,PO),(16#FE69#,16#FE69#,SC),
      (16#FE6A#,16#FE6B#,PO),(16#FE70#,16#FE74#,LO),(16#FE76#,16#FEFC#,LO),
      (16#FEFF#,16#FEFF#,CF),(16#FF01#,16#FF03#,PO),(16#FF04#,16#FF04#,SC),
      (16#FF05#,16#FF07#,PO),(16#FF08#,16#FF08#,PS),(16#FF09#,16#FF09#,PE),
      (16#FF0A#,16#FF0A#,PO),(16#FF0B#,16#FF0B#,SM),(16#FF0C#,16#FF0C#,PO),
      (16#FF0D#,16#FF0D#,PD),(16#FF0E#,16#FF0F#,PO),(16#FF10#,16#FF19#,ND),
      (16#FF1A#,16#FF1B#,PO),(16#FF1C#,16#FF1E#,SM),(16#FF1F#,16#FF20#,PO),
      (16#FF21#,16#FF3A#,LU),(16#FF3B#,16#FF3B#,PS),(16#FF3C#,16#FF3C#,PO),
      (16#FF3D#,16#FF3D#,PE),(16#FF3E#,16#FF3E#,SK),(16#FF3F#,16#FF3F#,PC),
      (16#FF40#,16#FF40#,SK),(16#FF41#,16#FF5A#,LL),(16#FF5B#,16#FF5B#,PS),
      (16#FF5C#,16#FF5C#,SM),(16#FF5D#,16#FF5D#,PE),(16#FF5E#,16#FF5E#,SM),
      (16#FF5F#,16#FF5F#,PS),(16#FF60#,16#FF60#,PE),(16#FF61#,16#FF61#,PO),
      (16#FF62#,16#FF62#,PS),(16#FF63#,16#FF63#,PE),(16#FF64#,16#FF65#,PO),
      (16#FF66#,16#FF6F#,LO),(16#FF70#,16#FF70#,LM),(16#FF71#,16#FF9D#,LO),
      (16#FF9E#,16#FF9F#,LM),(16#FFA0#,16#FFBE#,LO),(16#FFC2#,16#FFC7#,LO),
      (16#FFCA#,16#FFCF#,LO),(16#FFD2#,16#FFD7#,LO),(16#FFDA#,16#FFDC#,LO),
      (16#FFE0#,16#FFE1#,SC),(16#FFE2#,16#FFE2#,SM),(16#FFE3#,16#FFE3#,SK),
      (16#FFE4#,16#FFE4#,SO),(16#FFE5#,16#FFE6#,SC),(16#FFE8#,16#FFE8#,SO),
      (16#FFE9#,16#FFEC#,SM),(16#FFED#,16#FFEE#,SO),(16#FFF9#,16#FFFB#,CF),
      (16#FFFC#,16#FFFD#,SO),(16#10000#,16#1000B#,LO),(16#1000D#,16#10026#,LO),
      (16#10028#,16#1003A#,LO),(16#1003C#,16#1003D#,LO),(16#1003F#,16#1004D#,LO),
      (16#10050#,16#1005D#,LO),(16#10080#,16#100FA#,LO),(16#10100#,16#10102#,PO),
      (16#10107#,16#10133#,NO),(16#10137#,16#1013F#,SO),(16#10140#,16#10174#,NL),
      (16#10175#,16#10178#,NO),(16#10179#,16#10189#,SO),(16#1018A#,16#1018B#,NO),
      (16#1018C#,16#1018E#,SO),(16#10190#,16#1019C#,SO),(16#101A0#,16#101A0#,SO),
      (16#101D0#,16#101FC#,SO),(16#101FD#,16#101FD#,MN),(16#10280#,16#1029C#,LO),
      (16#102A0#,16#102D0#,LO),(16#102E0#,16#102E0#,MN),(16#102E1#,16#102FB#,NO),
      (16#10300#,16#1031F#,LO),(16#10320#,16#10323#,NO),(16#1032D#,16#10340#,LO),
      (16#10341#,16#10341#,NL),(16#10342#,16#10349#,LO),(16#1034A#,16#1034A#,NL),
      (16#10350#,16#10375#,LO),(16#10376#,16#1037A#,MN),(16#10380#,16#1039D#,LO),
      (16#1039F#,16#1039F#,PO),(16#103A0#,16#103C3#,LO),(16#103C8#,16#103CF#,LO),
      (16#103D0#,16#103D0#,PO),(16#103D1#,16#103D5#,NL),(16#10400#,16#10427#,LU),
      (16#10428#,16#1044F#,LL),(16#10450#,16#1049D#,LO),(16#104A0#,16#104A9#,ND),
      (16#104B0#,16#104D3#,LU),(16#104D8#,16#104FB#,LL),(16#10500#,16#10527#,LO),
      (16#10530#,16#10563#,LO),(16#1056F#,16#1056F#,PO),(16#10570#,16#1057A#,LU),
      (16#1057C#,16#1058A#,LU),(16#1058C#,16#10592#,LU),(16#10594#,16#10595#,LU),
      (16#10597#,16#105A1#,LL),(16#105A3#,16#105B1#,LL),(16#105B3#,16#105B9#,LL),
      (16#105BB#,16#105BC#,LL),(16#10600#,16#10736#,LO),(16#10740#,16#10755#,LO),
      (16#10760#,16#10767#,LO),(16#10780#,16#10785#,LM),(16#10787#,16#107B0#,LM),
      (16#107B2#,16#107BA#,LM),(16#10800#,16#10805#,LO),(16#10808#,16#10808#,LO),
      (16#1080A#,16#10835#,LO),(16#10837#,16#10838#,LO),(16#1083C#,16#1083C#,LO),
      (16#1083F#,16#10855#,LO),(16#10857#,16#10857#,PO),(16#10858#,16#1085F#,NO),
      (16#10860#,16#10876#,LO),(16#10877#,16#10878#,SO),(16#10879#,16#1087F#,NO),
      (16#10880#,16#1089E#,LO),(16#108A7#,16#108AF#,NO),(16#108E0#,16#108F2#,LO),
      (16#108F4#,16#108F5#,LO),(16#108FB#,16#108FF#,NO),(16#10900#,16#10915#,LO),
      (16#10916#,16#1091B#,NO),(16#1091F#,16#1091F#,PO),(16#10920#,16#10939#,LO),
      (16#1093F#,16#1093F#,PO),(16#10980#,16#109B7#,LO),(16#109BC#,16#109BD#,NO),
      (16#109BE#,16#109BF#,LO),(16#109C0#,16#109CF#,NO),(16#109D2#,16#109FF#,NO),
      (16#10A00#,16#10A00#,LO),(16#10A01#,16#10A03#,MN),(16#10A05#,16#10A06#,MN),
      (16#10A0C#,16#10A0F#,MN),(16#10A10#,16#10A13#,LO),(16#10A15#,16#10A17#,LO),
      (16#10A19#,16#10A35#,LO),(16#10A38#,16#10A3A#,MN),(16#10A3F#,16#10A3F#,MN),
      (16#10A40#,16#10A48#,NO),(16#10A50#,16#10A58#,PO),(16#10A60#,16#10A7C#,LO),
      (16#10A7D#,16#10A7E#,NO),(16#10A7F#,16#10A7F#,PO),(16#10A80#,16#10A9C#,LO),
      (16#10A9D#,16#10A9F#,NO),(16#10AC0#,16#10AC7#,LO),(16#10AC8#,16#10AC8#,SO),
      (16#10AC9#,16#10AE4#,LO),(16#10AE5#,16#10AE6#,MN),(16#10AEB#,16#10AEF#,NO),
      (16#10AF0#,16#10AF6#,PO),(16#10B00#,16#10B35#,LO),(16#10B39#,16#10B3F#,PO),
      (16#10B40#,16#10B55#,LO),(16#10B58#,16#10B5F#,NO),(16#10B60#,16#10B72#,LO),
      (16#10B78#,16#10B7F#,NO),(16#10B80#,16#10B91#,LO),(16#10B99#,16#10B9C#,PO),
      (16#10BA9#,16#10BAF#,NO),(16#10C00#,16#10C48#,LO),(16#10C80#,16#10CB2#,LU),
      (16#10CC0#,16#10CF2#,LL),(16#10CFA#,16#10CFF#,NO),(16#10D00#,16#10D23#,LO),
      (16#10D24#,16#10D27#,MN),(16#10D30#,16#10D39#,ND),(16#10E60#,16#10E7E#,NO),
      (16#10E80#,16#10EA9#,LO),(16#10EAB#,16#10EAC#,MN),(16#10EAD#,16#10EAD#,PD),
      (16#10EB0#,16#10EB1#,LO),(16#10EFD#,16#10EFF#,MN),(16#10F00#,16#10F1C#,LO),
      (16#10F1D#,16#10F26#,NO),(16#10F27#,16#10F27#,LO),(16#10F30#,16#10F45#,LO),
      (16#10F46#,16#10F50#,MN),(16#10F51#,16#10F54#,NO),(16#10F55#,16#10F59#,PO),
      (16#10F70#,16#10F81#,LO),(16#10F82#,16#10F85#,MN),(16#10F86#,16#10F89#,PO),
      (16#10FB0#,16#10FC4#,LO),(16#10FC5#,16#10FCB#,NO),(16#10FE0#,16#10FF6#,LO),
      (16#11000#,16#11000#,MC),(16#11001#,16#11001#,MN),(16#11002#,16#11002#,MC),
      (16#11003#,16#11037#,LO),(16#11038#,16#11046#,MN),(16#11047#,16#1104D#,PO),
      (16#11052#,16#11065#,NO),(16#11066#,16#1106F#,ND),(16#11070#,16#11070#,MN),
      (16#11071#,16#11072#,LO),(16#11073#,16#11074#,MN),(16#11075#,16#11075#,LO),
      (16#1107F#,16#11081#,MN),(16#11082#,16#11082#,MC),(16#11083#,16#110AF#,LO),
      (16#110B0#,16#110B2#,MC),(16#110B3#,16#110B6#,MN),(16#110B7#,16#110B8#,MC),
      (16#110B9#,16#110BA#,MN),(16#110BB#,16#110BC#,PO),(16#110BD#,16#110BD#,CF),
      (16#110BE#,16#110C1#,PO),(16#110C2#,16#110C2#,MN),(16#110CD#,16#110CD#,CF),
      (16#110D0#,16#110E8#,LO),(16#110F0#,16#110F9#,ND),(16#11100#,16#11102#,MN),
      (16#11103#,16#11126#,LO),(16#11127#,16#1112B#,MN),(16#1112C#,16#1112C#,MC),
      (16#1112D#,16#11134#,MN),(16#11136#,16#1113F#,ND),(16#11140#,16#11143#,PO),
      (16#11144#,16#11144#,LO),(16#11145#,16#11146#,MC),(16#11147#,16#11147#,LO),
      (16#11150#,16#11172#,LO),(16#11173#,16#11173#,MN),(16#11174#,16#11175#,PO),
      (16#11176#,16#11176#,LO),(16#11180#,16#11181#,MN),(16#11182#,16#11182#,MC),
      (16#11183#,16#111B2#,LO),(16#111B3#,16#111B5#,MC),(16#111B6#,16#111BE#,MN),
      (16#111BF#,16#111C0#,MC),(16#111C1#,16#111C4#,LO),(16#111C5#,16#111C8#,PO),
      (16#111C9#,16#111CC#,MN),(16#111CD#,16#111CD#,PO),(16#111CE#,16#111CE#,MC),
      (16#111CF#,16#111CF#,MN),(16#111D0#,16#111D9#,ND),(16#111DA#,16#111DA#,LO),
      (16#111DB#,16#111DB#,PO),(16#111DC#,16#111DC#,LO),(16#111DD#,16#111DF#,PO),
      (16#111E1#,16#111F4#,NO),(16#11200#,16#11211#,LO),(16#11213#,16#1122B#,LO),
      (16#1122C#,16#1122E#,MC),(16#1122F#,16#11231#,MN),(16#11232#,16#11233#,MC),
      (16#11234#,16#11234#,MN),(16#11235#,16#11235#,MC),(16#11236#,16#11237#,MN),
      (16#11238#,16#1123D#,PO),(16#1123E#,16#1123E#,MN),(16#1123F#,16#11240#,LO),
      (16#11241#,16#11241#,MN),(16#11280#,16#11286#,LO),(16#11288#,16#11288#,LO),
      (16#1128A#,16#1128D#,LO),(16#1128F#,16#1129D#,LO),(16#1129F#,16#112A8#,LO),
      (16#112A9#,16#112A9#,PO),(16#112B0#,16#112DE#,LO),(16#112DF#,16#112DF#,MN),
      (16#112E0#,16#112E2#,MC),(16#112E3#,16#112EA#,MN),(16#112F0#,16#112F9#,ND),
      (16#11300#,16#11301#,MN),(16#11302#,16#11303#,MC),(16#11305#,16#1130C#,LO),
      (16#1130F#,16#11310#,LO),(16#11313#,16#11328#,LO),(16#1132A#,16#11330#,LO),
      (16#11332#,16#11333#,LO),(16#11335#,16#11339#,LO),(16#1133B#,16#1133C#,MN),
      (16#1133D#,16#1133D#,LO),(16#1133E#,16#1133F#,MC),(16#11340#,16#11340#,MN),
      (16#11341#,16#11344#,MC),(16#11347#,16#11348#,MC),(16#1134B#,16#1134D#,MC),
      (16#11350#,16#11350#,LO),(16#11357#,16#11357#,MC),(16#1135D#,16#11361#,LO),
      (16#11362#,16#11363#,MC),(16#11366#,16#1136C#,MN),(16#11370#,16#11374#,MN),
      (16#11400#,16#11434#,LO),(16#11435#,16#11437#,MC),(16#11438#,16#1143F#,MN),
      (16#11440#,16#11441#,MC),(16#11442#,16#11444#,MN),(16#11445#,16#11445#,MC),
      (16#11446#,16#11446#,MN),(16#11447#,16#1144A#,LO),(16#1144B#,16#1144F#,PO),
      (16#11450#,16#11459#,ND),(16#1145A#,16#1145B#,PO),(16#1145D#,16#1145D#,PO),
      (16#1145E#,16#1145E#,MN),(16#1145F#,16#11461#,LO),(16#11480#,16#114AF#,LO),
      (16#114B0#,16#114B2#,MC),(16#114B3#,16#114B8#,MN),(16#114B9#,16#114B9#,MC),
      (16#114BA#,16#114BA#,MN),(16#114BB#,16#114BE#,MC),(16#114BF#,16#114C0#,MN),
      (16#114C1#,16#114C1#,MC),(16#114C2#,16#114C3#,MN),(16#114C4#,16#114C5#,LO),
      (16#114C6#,16#114C6#,PO),(16#114C7#,16#114C7#,LO),(16#114D0#,16#114D9#,ND),
      (16#11580#,16#115AE#,LO),(16#115AF#,16#115B1#,MC),(16#115B2#,16#115B5#,MN),
      (16#115B8#,16#115BB#,MC),(16#115BC#,16#115BD#,MN),(16#115BE#,16#115BE#,MC),
      (16#115BF#,16#115C0#,MN),(16#115C1#,16#115D7#,PO),(16#115D8#,16#115DB#,LO),
      (16#115DC#,16#115DD#,MN),(16#11600#,16#1162F#,LO),(16#11630#,16#11632#,MC),
      (16#11633#,16#1163A#,MN),(16#1163B#,16#1163C#,MC),(16#1163D#,16#1163D#,MN),
      (16#1163E#,16#1163E#,MC),(16#1163F#,16#11640#,MN),(16#11641#,16#11643#,PO),
      (16#11644#,16#11644#,LO),(16#11650#,16#11659#,ND),(16#11660#,16#1166C#,PO),
      (16#11680#,16#116AA#,LO),(16#116AB#,16#116AB#,MN),(16#116AC#,16#116AC#,MC),
      (16#116AD#,16#116AD#,MN),(16#116AE#,16#116AF#,MC),(16#116B0#,16#116B5#,MN),
      (16#116B6#,16#116B6#,MC),(16#116B7#,16#116B7#,MN),(16#116B8#,16#116B8#,LO),
      (16#116B9#,16#116B9#,PO),(16#116C0#,16#116C9#,ND),(16#11700#,16#1171A#,LO),
      (16#1171D#,16#1171F#,MN),(16#11720#,16#11721#,MC),(16#11722#,16#11725#,MN),
      (16#11726#,16#11726#,MC),(16#11727#,16#1172B#,MN),(16#11730#,16#11739#,ND),
      (16#1173A#,16#1173B#,NO),(16#1173C#,16#1173E#,PO),(16#1173F#,16#1173F#,SO),
      (16#11740#,16#11746#,LO),(16#11800#,16#1182B#,LO),(16#1182C#,16#1182E#,MC),
      (16#1182F#,16#11837#,MN),(16#11838#,16#11838#,MC),(16#11839#,16#1183A#,MN),
      (16#1183B#,16#1183B#,PO),(16#118A0#,16#118BF#,LU),(16#118C0#,16#118DF#,LL),
      (16#118E0#,16#118E9#,ND),(16#118EA#,16#118F2#,NO),(16#118FF#,16#11906#,LO),
      (16#11909#,16#11909#,LO),(16#1190C#,16#11913#,LO),(16#11915#,16#11916#,LO),
      (16#11918#,16#1192F#,LO),(16#11930#,16#11935#,MC),(16#11937#,16#11938#,MC),
      (16#1193B#,16#1193C#,MN),(16#1193D#,16#1193D#,MC),(16#1193E#,16#1193E#,MN),
      (16#1193F#,16#1193F#,LO),(16#11940#,16#11940#,MC),(16#11941#,16#11941#,LO),
      (16#11942#,16#11942#,MC),(16#11943#,16#11943#,MN),(16#11944#,16#11946#,PO),
      (16#11950#,16#11959#,ND),(16#119A0#,16#119A7#,LO),(16#119AA#,16#119D0#,LO),
      (16#119D1#,16#119D3#,MC),(16#119D4#,16#119D7#,MN),(16#119DA#,16#119DB#,MN),
      (16#119DC#,16#119DF#,MC),(16#119E0#,16#119E0#,MN),(16#119E1#,16#119E1#,LO),
      (16#119E2#,16#119E2#,PO),(16#119E3#,16#119E3#,LO),(16#119E4#,16#119E4#,MC),
      (16#11A00#,16#11A00#,LO),(16#11A01#,16#11A0A#,MN),(16#11A0B#,16#11A32#,LO),
      (16#11A33#,16#11A38#,MN),(16#11A39#,16#11A39#,MC),(16#11A3A#,16#11A3A#,LO),
      (16#11A3B#,16#11A3E#,MN),(16#11A3F#,16#11A46#,PO),(16#11A47#,16#11A47#,MN),
      (16#11A50#,16#11A50#,LO),(16#11A51#,16#11A56#,MN),(16#11A57#,16#11A58#,MC),
      (16#11A59#,16#11A5B#,MN),(16#11A5C#,16#11A89#,LO),(16#11A8A#,16#11A96#,MN),
      (16#11A97#,16#11A97#,MC),(16#11A98#,16#11A99#,MN),(16#11A9A#,16#11A9C#,PO),
      (16#11A9D#,16#11A9D#,LO),(16#11A9E#,16#11AA2#,PO),(16#11AB0#,16#11AF8#,LO),
      (16#11B00#,16#11B09#,PO),(16#11C00#,16#11C08#,LO),(16#11C0A#,16#11C2E#,LO),
      (16#11C2F#,16#11C2F#,MC),(16#11C30#,16#11C36#,MN),(16#11C38#,16#11C3D#,MN),
      (16#11C3E#,16#11C3E#,MC),(16#11C3F#,16#11C3F#,MN),(16#11C40#,16#11C40#,LO),
      (16#11C41#,16#11C45#,PO),(16#11C50#,16#11C59#,ND),(16#11C5A#,16#11C6C#,NO),
      (16#11C70#,16#11C71#,PO),(16#11C72#,16#11C8F#,LO),(16#11C92#,16#11CA7#,MN),
      (16#11CA9#,16#11CA9#,MC),(16#11CAA#,16#11CB0#,MN),(16#11CB1#,16#11CB1#,MC),
      (16#11CB2#,16#11CB3#,MN),(16#11CB4#,16#11CB4#,MC),(16#11CB5#,16#11CB6#,MN),
      (16#11D00#,16#11D06#,LO),(16#11D08#,16#11D09#,LO),(16#11D0B#,16#11D30#,LO),
      (16#11D31#,16#11D36#,MN),(16#11D3A#,16#11D3A#,MN),(16#11D3C#,16#11D3D#,MN),
      (16#11D3F#,16#11D45#,MN),(16#11D46#,16#11D46#,LO),(16#11D47#,16#11D47#,MN),
      (16#11D50#,16#11D59#,ND),(16#11D60#,16#11D65#,LO),(16#11D67#,16#11D68#,LO),
      (16#11D6A#,16#11D89#,LO),(16#11D8A#,16#11D8E#,MC),(16#11D90#,16#11D91#,MN),
      (16#11D93#,16#11D94#,MC),(16#11D95#,16#11D95#,MN),(16#11D96#,16#11D96#,MC),
      (16#11D97#,16#11D97#,MN),(16#11D98#,16#11D98#,LO),(16#11DA0#,16#11DA9#,ND),
      (16#11EE0#,16#11EF2#,LO),(16#11EF3#,16#11EF4#,MN),(16#11EF5#,16#11EF6#,MC),
      (16#11EF7#,16#11EF8#,PO),(16#11F00#,16#11F01#,MN),(16#11F02#,16#11F02#,LO),
      (16#11F03#,16#11F03#,MC),(16#11F04#,16#11F10#,LO),(16#11F12#,16#11F33#,LO),
      (16#11F34#,16#11F35#,MC),(16#11F36#,16#11F3A#,MN),(16#11F3E#,16#11F3F#,MC),
      (16#11F40#,16#11F40#,MN),(16#11F41#,16#11F41#,MC),(16#11F42#,16#11F42#,MN),
      (16#11F43#,16#11F4F#,PO),(16#11F50#,16#11F59#,ND),(16#11FB0#,16#11FB0#,LO),
      (16#11FC0#,16#11FD4#,NO),(16#11FD5#,16#11FDC#,SO),(16#11FDD#,16#11FE0#,SC),
      (16#11FE1#,16#11FF1#,SO),(16#11FFF#,16#11FFF#,PO),(16#12000#,16#12399#,LO),
      (16#12400#,16#1246E#,NL),(16#12470#,16#12474#,PO),(16#12480#,16#12543#,LO),
      (16#12F90#,16#12FF0#,LO),(16#12FF1#,16#12FF2#,PO),(16#13000#,16#1342F#,LO),
      (16#13430#,16#1343F#,CF),(16#13440#,16#13440#,MN),(16#13441#,16#13446#,LO),
      (16#13447#,16#13455#,MN),(16#14400#,16#14646#,LO),(16#16800#,16#16A38#,LO),
      (16#16A40#,16#16A5E#,LO),(16#16A60#,16#16A69#,ND),(16#16A6E#,16#16A6F#,PO),
      (16#16A70#,16#16ABE#,LO),(16#16AC0#,16#16AC9#,ND),(16#16AD0#,16#16AED#,LO),
      (16#16AF0#,16#16AF4#,MN),(16#16AF5#,16#16AF5#,PO),(16#16B00#,16#16B2F#,LO),
      (16#16B30#,16#16B36#,MN),(16#16B37#,16#16B3B#,PO),(16#16B3C#,16#16B3F#,SO),
      (16#16B40#,16#16B43#,LM),(16#16B44#,16#16B44#,PO),(16#16B45#,16#16B45#,SO),
      (16#16B50#,16#16B59#,ND),(16#16B5B#,16#16B61#,NO),(16#16B63#,16#16B77#,LO),
      (16#16B7D#,16#16B8F#,LO),(16#16E40#,16#16E5F#,LU),(16#16E60#,16#16E7F#,LL),
      (16#16E80#,16#16E96#,NO),(16#16E97#,16#16E9A#,PO),(16#16F00#,16#16F4A#,LO),
      (16#16F4F#,16#16F4F#,MN),(16#16F50#,16#16F50#,LO),(16#16F51#,16#16F87#,MC),
      (16#16F8F#,16#16F92#,MN),(16#16F93#,16#16F9F#,LM),(16#16FE0#,16#16FE1#,LM),
      (16#16FE2#,16#16FE2#,PO),(16#16FE3#,16#16FE3#,LM),(16#16FE4#,16#16FE4#,MN),
      (16#16FF0#,16#16FF1#,MC),(16#17000#,16#17000#,LO),(16#187F7#,16#187F7#,LO),
      (16#18800#,16#18CD5#,LO),(16#18D00#,16#18D00#,LO),(16#18D08#,16#18D08#,LO),
      (16#1AFF0#,16#1AFF3#,LM),(16#1AFF5#,16#1AFFB#,LM),(16#1AFFD#,16#1AFFE#,LM),
      (16#1B000#,16#1B122#,LO),(16#1B132#,16#1B132#,LO),(16#1B150#,16#1B152#,LO),
      (16#1B155#,16#1B155#,LO),(16#1B164#,16#1B167#,LO),(16#1B170#,16#1B2FB#,LO),
      (16#1BC00#,16#1BC6A#,LO),(16#1BC70#,16#1BC7C#,LO),(16#1BC80#,16#1BC88#,LO),
      (16#1BC90#,16#1BC99#,LO),(16#1BC9C#,16#1BC9C#,SO),(16#1BC9D#,16#1BC9E#,MN),
      (16#1BC9F#,16#1BC9F#,PO),(16#1BCA0#,16#1BCA3#,CF),(16#1CF00#,16#1CF2D#,MN),
      (16#1CF30#,16#1CF46#,MN),(16#1CF50#,16#1CFC3#,SO),(16#1D000#,16#1D0F5#,SO),
      (16#1D100#,16#1D126#,SO),(16#1D129#,16#1D164#,SO),(16#1D165#,16#1D166#,MC),
      (16#1D167#,16#1D169#,MN),(16#1D16A#,16#1D16C#,SO),(16#1D16D#,16#1D172#,MC),
      (16#1D173#,16#1D17A#,CF),(16#1D17B#,16#1D182#,MN),(16#1D183#,16#1D184#,SO),
      (16#1D185#,16#1D18B#,MN),(16#1D18C#,16#1D1A9#,SO),(16#1D1AA#,16#1D1AD#,MN),
      (16#1D1AE#,16#1D1EA#,SO),(16#1D200#,16#1D241#,SO),(16#1D242#,16#1D244#,MN),
      (16#1D245#,16#1D245#,SO),(16#1D2C0#,16#1D2D3#,NO),(16#1D2E0#,16#1D2F3#,NO),
      (16#1D300#,16#1D356#,SO),(16#1D360#,16#1D378#,NO),(16#1D400#,16#1D419#,LU),
      (16#1D41A#,16#1D433#,LL),(16#1D434#,16#1D44D#,LU),(16#1D44E#,16#1D454#,LL),
      (16#1D456#,16#1D467#,LL),(16#1D468#,16#1D481#,LU),(16#1D482#,16#1D49B#,LL),
      (16#1D49C#,16#1D49C#,LU),(16#1D49E#,16#1D49F#,LU),(16#1D4A2#,16#1D4A2#,LU),
      (16#1D4A5#,16#1D4A6#,LU),(16#1D4A9#,16#1D4AC#,LU),(16#1D4AE#,16#1D4B5#,LU),
      (16#1D4B6#,16#1D4B9#,LL),(16#1D4BB#,16#1D4BB#,LL),(16#1D4BD#,16#1D4C3#,LL),
      (16#1D4C5#,16#1D4CF#,LL),(16#1D4D0#,16#1D4E9#,LU),(16#1D4EA#,16#1D503#,LL),
      (16#1D504#,16#1D505#,LU),(16#1D507#,16#1D50A#,LU),(16#1D50D#,16#1D514#,LU),
      (16#1D516#,16#1D51C#,LU),(16#1D51E#,16#1D537#,LL),(16#1D538#,16#1D539#,LU),
      (16#1D53B#,16#1D53E#,LU),(16#1D540#,16#1D544#,LU),(16#1D546#,16#1D546#,LU),
      (16#1D54A#,16#1D550#,LU),(16#1D552#,16#1D56B#,LL),(16#1D56C#,16#1D585#,LU),
      (16#1D586#,16#1D59F#,LL),(16#1D5A0#,16#1D5B9#,LU),(16#1D5BA#,16#1D5D3#,LL),
      (16#1D5D4#,16#1D5ED#,LU),(16#1D5EE#,16#1D607#,LL),(16#1D608#,16#1D621#,LU),
      (16#1D622#,16#1D63B#,LL),(16#1D63C#,16#1D655#,LU),(16#1D656#,16#1D66F#,LL),
      (16#1D670#,16#1D689#,LU),(16#1D68A#,16#1D6A5#,LL),(16#1D6A8#,16#1D6C0#,LU),
      (16#1D6C1#,16#1D6C1#,SM),(16#1D6C2#,16#1D6DA#,LL),(16#1D6DB#,16#1D6DB#,SM),
      (16#1D6DC#,16#1D6E1#,LL),(16#1D6E2#,16#1D6FA#,LU),(16#1D6FB#,16#1D6FB#,SM),
      (16#1D6FC#,16#1D714#,LL),(16#1D715#,16#1D715#,SM),(16#1D716#,16#1D71B#,LL),
      (16#1D71C#,16#1D734#,LU),(16#1D735#,16#1D735#,SM),(16#1D736#,16#1D74E#,LL),
      (16#1D74F#,16#1D74F#,SM),(16#1D750#,16#1D755#,LL),(16#1D756#,16#1D76E#,LU),
      (16#1D76F#,16#1D76F#,SM),(16#1D770#,16#1D788#,LL),(16#1D789#,16#1D789#,SM),
      (16#1D78A#,16#1D78F#,LL),(16#1D790#,16#1D7A8#,LU),(16#1D7A9#,16#1D7A9#,SM),
      (16#1D7AA#,16#1D7C2#,LL),(16#1D7C3#,16#1D7C3#,SM),(16#1D7C4#,16#1D7C9#,LL),
      (16#1D7CA#,16#1D7CA#,LU),(16#1D7CB#,16#1D7CB#,LL),(16#1D7CE#,16#1D7FF#,ND),
      (16#1D800#,16#1D9FF#,SO),(16#1DA00#,16#1DA36#,MN),(16#1DA37#,16#1DA3A#,SO),
      (16#1DA3B#,16#1DA6C#,MN),(16#1DA6D#,16#1DA74#,SO),(16#1DA75#,16#1DA75#,MN),
      (16#1DA76#,16#1DA83#,SO),(16#1DA84#,16#1DA84#,MN),(16#1DA85#,16#1DA86#,SO),
      (16#1DA87#,16#1DA8B#,PO),(16#1DA9B#,16#1DA9F#,MN),(16#1DAA1#,16#1DAAF#,MN),
      (16#1DF00#,16#1DF09#,LL),(16#1DF0A#,16#1DF0A#,LO),(16#1DF0B#,16#1DF1E#,LL),
      (16#1DF25#,16#1DF2A#,LL),(16#1E000#,16#1E006#,MN),(16#1E008#,16#1E018#,MN),
      (16#1E01B#,16#1E021#,MN),(16#1E023#,16#1E024#,MN),(16#1E026#,16#1E02A#,MN),
      (16#1E030#,16#1E06D#,LM),(16#1E08F#,16#1E08F#,MN),(16#1E100#,16#1E12C#,LO),
      (16#1E130#,16#1E136#,MN),(16#1E137#,16#1E13D#,LM),(16#1E140#,16#1E149#,ND),
      (16#1E14E#,16#1E14E#,LO),(16#1E14F#,16#1E14F#,SO),(16#1E290#,16#1E2AD#,LO),
      (16#1E2AE#,16#1E2AE#,MN),(16#1E2C0#,16#1E2EB#,LO),(16#1E2EC#,16#1E2EF#,MN),
      (16#1E2F0#,16#1E2F9#,ND),(16#1E2FF#,16#1E2FF#,SC),(16#1E4D0#,16#1E4EA#,LO),
      (16#1E4EB#,16#1E4EB#,LM),(16#1E4EC#,16#1E4EF#,MN),(16#1E4F0#,16#1E4F9#,ND),
      (16#1E7E0#,16#1E7E6#,LO),(16#1E7E8#,16#1E7EB#,LO),(16#1E7ED#,16#1E7EE#,LO),
      (16#1E7F0#,16#1E7FE#,LO),(16#1E800#,16#1E8C4#,LO),(16#1E8C7#,16#1E8CF#,NO),
      (16#1E8D0#,16#1E8D6#,MN),(16#1E900#,16#1E921#,LU),(16#1E922#,16#1E943#,LL),
      (16#1E944#,16#1E94A#,MN),(16#1E94B#,16#1E94B#,LM),(16#1E950#,16#1E959#,ND),
      (16#1E95E#,16#1E95F#,PO),(16#1EC71#,16#1ECAB#,NO),(16#1ECAC#,16#1ECAC#,SO),
      (16#1ECAD#,16#1ECAF#,NO),(16#1ECB0#,16#1ECB0#,SC),(16#1ECB1#,16#1ECB4#,NO),
      (16#1ED01#,16#1ED2D#,NO),(16#1ED2E#,16#1ED2E#,SO),(16#1ED2F#,16#1ED3D#,NO),
      (16#1EE00#,16#1EE03#,LO),(16#1EE05#,16#1EE1F#,LO),(16#1EE21#,16#1EE22#,LO),
      (16#1EE24#,16#1EE24#,LO),(16#1EE27#,16#1EE27#,LO),(16#1EE29#,16#1EE32#,LO),
      (16#1EE34#,16#1EE37#,LO),(16#1EE39#,16#1EE39#,LO),(16#1EE3B#,16#1EE3B#,LO),
      (16#1EE42#,16#1EE42#,LO),(16#1EE47#,16#1EE47#,LO),(16#1EE49#,16#1EE49#,LO),
      (16#1EE4B#,16#1EE4B#,LO),(16#1EE4D#,16#1EE4F#,LO),(16#1EE51#,16#1EE52#,LO),
      (16#1EE54#,16#1EE54#,LO),(16#1EE57#,16#1EE57#,LO),(16#1EE59#,16#1EE59#,LO),
      (16#1EE5B#,16#1EE5B#,LO),(16#1EE5D#,16#1EE5D#,LO),(16#1EE5F#,16#1EE5F#,LO),
      (16#1EE61#,16#1EE62#,LO),(16#1EE64#,16#1EE64#,LO),(16#1EE67#,16#1EE6A#,LO),
      (16#1EE6C#,16#1EE72#,LO),(16#1EE74#,16#1EE77#,LO),(16#1EE79#,16#1EE7C#,LO),
      (16#1EE7E#,16#1EE7E#,LO),(16#1EE80#,16#1EE89#,LO),(16#1EE8B#,16#1EE9B#,LO),
      (16#1EEA1#,16#1EEA3#,LO),(16#1EEA5#,16#1EEA9#,LO),(16#1EEAB#,16#1EEBB#,LO),
      (16#1EEF0#,16#1EEF1#,SM),(16#1F000#,16#1F02B#,SO),(16#1F030#,16#1F093#,SO),
      (16#1F0A0#,16#1F0AE#,SO),(16#1F0B1#,16#1F0BF#,SO),(16#1F0C1#,16#1F0CF#,SO),
      (16#1F0D1#,16#1F0F5#,SO),(16#1F100#,16#1F10C#,NO),(16#1F10D#,16#1F1AD#,SO),
      (16#1F1E6#,16#1F202#,SO),(16#1F210#,16#1F23B#,SO),(16#1F240#,16#1F248#,SO),
      (16#1F250#,16#1F251#,SO),(16#1F260#,16#1F265#,SO),(16#1F300#,16#1F3FA#,SO),
      (16#1F3FB#,16#1F3FF#,SK),(16#1F400#,16#1F6D7#,SO),(16#1F6DC#,16#1F6EC#,SO),
      (16#1F6F0#,16#1F6FC#,SO),(16#1F700#,16#1F776#,SO),(16#1F77B#,16#1F7D9#,SO),
      (16#1F7E0#,16#1F7EB#,SO),(16#1F7F0#,16#1F7F0#,SO),(16#1F800#,16#1F80B#,SO),
      (16#1F810#,16#1F847#,SO),(16#1F850#,16#1F859#,SO),(16#1F860#,16#1F887#,SO),
      (16#1F890#,16#1F8AD#,SO),(16#1F8B0#,16#1F8B1#,SO),(16#1F900#,16#1FA53#,SO),
      (16#1FA60#,16#1FA6D#,SO),(16#1FA70#,16#1FA7C#,SO),(16#1FA80#,16#1FA88#,SO),
      (16#1FA90#,16#1FABD#,SO),(16#1FABF#,16#1FAC5#,SO),(16#1FACE#,16#1FADB#,SO),
      (16#1FAE0#,16#1FAE8#,SO),(16#1FAF0#,16#1FAF8#,SO),(16#1FB00#,16#1FB92#,SO),
      (16#1FB94#,16#1FBCA#,SO),(16#1FBF0#,16#1FBF9#,ND),(16#20000#,16#20000#,LO),
      (16#2A6DF#,16#2A6DF#,LO),(16#2A700#,16#2A700#,LO),(16#2B739#,16#2B739#,LO),
      (16#2B740#,16#2B740#,LO),(16#2B81D#,16#2B81D#,LO),(16#2B820#,16#2B820#,LO),
      (16#2CEA1#,16#2CEA1#,LO),(16#2CEB0#,16#2CEB0#,LO),(16#2EBE0#,16#2EBE0#,LO),
      (16#2F800#,16#2FA1D#,LO),(16#30000#,16#30000#,LO),(16#3134A#,16#3134A#,LO),
      (16#31350#,16#31350#,LO),(16#323AF#,16#323AF#,LO),(16#E0001#,16#E0001#,CF),
      (16#E0020#,16#E007F#,CF),(16#E0100#,16#E01EF#,MN),(16#F0000#,16#F0000#,CO),
      (16#FFFFD#,16#FFFFD#,CO),(16#100000#,16#100000#,CO),(16#10FFFD#,16#10FFFD#,CO)
   );

   function Category (Value : UTF8_Code_Point)
      return General_Category is
      From : Range_Index := Mapping'First;
      To   : Range_Index := Mapping'Last;
      This : Range_Index;
      Current : Points_Range;
   begin
      loop
         This := (From + To) / 2;
         Current := Mapping (This);
         if Current.From > Value then
            exit when This = From;
            To := This - 1;
         elsif Current.To < Value then
            exit when This = To;
            From := This + 1;
         else
            return Current.Category;
         end if;
      end loop;
      return Co;
   end Category;

   function Is_Alphanumeric (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      case Category (Value) is
         when Letter | Nd =>
            return True;
         when others =>
            return False;
      end case;
   end Is_Alphanumeric;

   function Is_Control (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Cc;
   end Is_Control;

   function Is_Identifier_Extend (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      case Category (Value) is
         when Mn | Mc | Nd | Pc | Cf =>
            return True;
         when others =>
            return False;
      end case;
   end Is_Identifier_Extend;

   function Is_Identifier_Start (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      case Category (Value) is
         when Letter | Nl =>
            return True;
         when others =>
            return False;
      end case;
   end Is_Identifier_Start;

   function Is_ISO_646 (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Value <= 16#7F#;
   end Is_ISO_646;

   function Is_Letter (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) in Letter;
   end Is_Letter;

   function Is_Lower (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Ll;
   end Is_Lower;

   function Is_Digit (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Nd;
   end Is_Digit;

   function Is_Other_Format (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      return Category (Value) = Cf;
   end Is_Other_Format;

   function Is_Space (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Zs;
   end Is_Space;

   function Is_Subscript_Digit (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      return Value in 16#2080#..16#208A#;
   end Is_Subscript_Digit;

   function Is_Superscript_Digit (Value : in UTF8_Code_Point)
      return Boolean is
   begin
      case Value is
         when 16#B2#..16#B3# | 16#B9# | 16#2070#..16#2079# =>
            return True;
         when others =>
            return False;
      end case;
   end Is_Superscript_Digit;

   function Is_Title (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Lt;
   end Is_Title;

   function Is_Upper (Value : in UTF8_Code_Point) return Boolean is
   begin
      return Category (Value) = Lu;
   end Is_Upper;

end Strings_Edit.UTF8.Categorization;
